/**
 * Copyright krogue ( http://wonderfl.net/user/krogue )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/cow5
 */

/**
 * #15 Shaker Sort 2
 * 
 * 概要:
 * 「Bubble Sort」を見ていて、特別高速ではないが、個人的に好きなソートアルゴリズムである
 * 「Shaker Sort」を作りたくなった。それだけ。
 * 
 * 操作:
 * ・スペースキー: リセット
 * 
 * 参考:
 * ・「Bubble Sort」
 *   http://wonderfl.net/code/7c88245b1e2b77064d85501b7984c7b00f000b7b
 * 
 * メモ:
 * いいかげんなクラス分割
 * BitmapDataの嵐
 * 7セグ使ってみた(「#8 7セグ」とは随分異なる)
 * いいかげんなHSV->RGB変換使ってみた(「#13 Cross」から流用)
 * 交換や確定箇所のエフェクト考えたが面倒なのでやめ(2になっているのは1でいくつか試したため)
 * HSVぽいのじゃなく0xFF0000..0xFFFF00みたくすれば良かったかも
 * 
 * @author krogue
 */
package  {
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.events.KeyboardEvent;
    import flash.system.IME;
    import flash.ui.Keyboard;
    
    [SWF(width="465", height="465", backgroundColor="0", frameRate="60")]
    public class Main extends Sprite {
        private var sort:ShakerSort;
        
        public function Main() {
            addEventListener(Event.ADDED_TO_STAGE, onAddedToStage);
        }
        
        private function onAddedToStage(event:Event):void {
            removeEventListener(Event.ADDED_TO_STAGE, onAddedToStage);
            initialize();
            addEventListener(Event.ENTER_FRAME, onEnterFrame);
        }
        
        private function onEnterFrame(event:Event):void {
            update();
        }
        
        private function initialize():void {
            IME.enabled = false;
            sort = addChild(new ShakerSort()) as ShakerSort;
            stage.addEventListener(KeyboardEvent.KEY_UP, onKeyUp);
        }
        
        private function update():void {
            sort.update();
        }
        
        private function onKeyUp(event:KeyboardEvent):void {
            if (event.keyCode == Keyboard.SPACE) {
                sort.reset();
            }
        }
    }
}

import __AS3__.vec.Vector;
import flash.display.Graphics;
import flash.display.Shape;
import flash.display.Sprite;
import flash.display.BitmapData;
import flash.display.Bitmap;
import flash.geom.Matrix;
import flash.geom.Rectangle;

class ShakerSort extends Sprite {
    private const pool:Vector.<BitmapData> = new Vector.<BitmapData>(100);
    private var bitmap:Bitmap = addChild(new Bitmap()) as Bitmap;
    private var items:Vector.<int> = new Vector.<int>(Math.pow(465 / 31, 2));
    // ソート用変数
    private var isSorted:Boolean;
    private var lastSwappedIndex:int;
    private var leftIndex:int;
    private var rightIndex:int;
    private var currentIndex:int;
    private var isLeftToRight:Boolean;
    
    public function ShakerSort() {
        for (var i:int = 0; i < pool.length; i++) {
            pool[i] = build(i);
        }
        bitmap.bitmapData = new BitmapData(465, 465, true, 0x00000000);
        reset();
    }
    
    public function reset():void {
        for (var i:int = 0; i < items.length; i++) {
            items[i] = Math.floor(Math.random() * pool.length);
        }
        isSorted = false;
        isLeftToRight = true;
        lastSwappedIndex = 0;
        leftIndex = 0;
        rightIndex = items.length - 1;
        currentIndex = 0;
        drawItems();
    }
    
    public function update():void {
        if (isSorted || leftIndex >= rightIndex) {
            isSorted = true;
            return;
        }
        if (isLeftToRight) {
            if (items[currentIndex] > items[currentIndex + 1]) {
                swap(currentIndex, currentIndex + 1);
                lastSwappedIndex = currentIndex;
            }
            if (++currentIndex >= rightIndex) {
                if (currentIndex == lastSwappedIndex) {
                    isSorted = true;
                }
                rightIndex = lastSwappedIndex;
                currentIndex = lastSwappedIndex;
                isLeftToRight = false;
            }
        } else {
            if (items[currentIndex - 1] > items[currentIndex]) {
                swap(currentIndex - 1, currentIndex);
                lastSwappedIndex = currentIndex;
            }
            if (--currentIndex <= leftIndex) {
                if (currentIndex == lastSwappedIndex) {
                    isSorted = true;
                }
                leftIndex = lastSwappedIndex;
                currentIndex = lastSwappedIndex;
                isLeftToRight = true;
            }
        }
    }
    
    private function build(n:uint):BitmapData {
        if (n < 0 || 99 < n) {
            throw new ArgumentError();
        }
        // 0..99 => 0..359 => 0xFFxxxxxx
        const cfg:uint = h2rgb(Math.floor(n * 360 / 100));
        const cbg:uint = 0x00000000;
        const itemRect:Rectangle = new Rectangle(0, 0, 25, 25);
        const bw:int = 1; // border width
        const bmd:BitmapData = new BitmapData(25, 25, true, cbg);
        const shape:Shape = new Shape();
        const g:Graphics = shape.graphics;
        g.lineStyle(bw, cfg);
        g.drawRect(0, 0, bmd.rect.width - bw, bmd.rect.height - bw);
        bmd.draw(shape);
        bmd.draw(SevenSegmentBitmapData.build(Math.floor(n / 10), cfg, cbg),
            new Matrix(1, 0, 0, 1, 2, 2));
        bmd.draw(SevenSegmentBitmapData.build(Math.floor(n % 10), cfg, cbg),
            new Matrix(1, 0, 0, 1, 13, 2));
        return bmd;
    }
    
    private function drawItems():void {
        const bmd:BitmapData = bitmap.bitmapData;
        bmd.lock();
        bmd.fillRect(bmd.rect, 0x00000000);
        const bsize:int = 31;
        const bnum:int = 465 / bsize;
        for (var y:int = 0; y < bnum; y++) {
            for (var x:int = 0; x < bnum; x++) {
                bmd.draw(pool[items[y * bnum + x]],
                    new Matrix(1, 0, 0, 1, 3 + x * bsize, 3 + y * bsize));
            }
        }
        bmd.unlock();
    }
    
    private function swap(i:int, j:int):void {
        var w:uint = items[i];
        items[i] = items[j];
        items[j] = w;
        drawItems();
    }
    
    // HSV -> RGB ( H=0..359 S=1, V=255 )
    private function h2rgb(h:Number):uint {
        var color:uint = 0xFF000000;
        const v:uint = 0xFF; // 255
        const hi:Number = Math.floor(h / 60);
        const f:Number = v * (h / 60 - hi);
        switch (hi) {
        case 0:
            color |= ((v << 16) | (f << 8));
            break;
        case 1:
            color |= (((v - f) << 16) | (v << 8));
            break;
        case 2:
            color |= ((v << 8) | f);
            break;
        case 3:
            color |= (((v - f) << 8) | v);
            break;
        case 4:
            color |= ((f << 16) | v);
            break;
        case 5:
            color |= ((v << 16) | (v - f));
            break;
        }
        return color;
    }
}

class SevenSegmentBitmapData {
    public static function build(i:uint, cf:uint, cb:uint):BitmapData {
        if (i < 0 || 9 < i) {
            throw new ArgumentError();
        }
        const data:Array = SevenSegmentData.data[i];
        const w:int = SevenSegmentData.WIDTH;
        const h:int = SevenSegmentData.HEIGHT;
        const bmd:BitmapData = new BitmapData(w, h, true, cb);
        for (var y:int = 0; y < h; y++) {
            for (var x:int = 0; x < w; x++) {
                bmd.setPixel32(x, y, (data[y * w + x] != 0 ? cf : cb));
            }
        }
        return bmd;
    }
}

class SevenSegmentData {
    public static const WIDTH:int = 10;
    public static const HEIGHT:int = 21;
    private static const data0:Array /* of uint */ = [
        0, 1, 1, 1, 1, 1, 1, 1, 1, 0,
        1, 0, 1, 1, 1, 1, 1, 1, 0, 1,
        1, 1, 0, 0, 0, 0, 0, 0, 1, 1,
        1, 1, 0, 0, 0, 0, 0, 0, 1, 1,
        1, 1, 0, 0, 0, 0, 0, 0, 1, 1,
        1, 1, 0, 0, 0, 0, 0, 0, 1, 1,
        1, 1, 0, 0, 0, 0, 0, 0, 1, 1,
        1, 1, 0, 0, 0, 0, 0, 0, 1, 1,
        1, 1, 0, 0, 0, 0, 0, 0, 1, 1,
        1, 0, 0, 0, 0, 0, 0, 0, 0, 1,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        1, 0, 0, 0, 0, 0, 0, 0, 0, 1,
        1, 1, 0, 0, 0, 0, 0, 0, 1, 1,
        1, 1, 0, 0, 0, 0, 0, 0, 1, 1,
        1, 1, 0, 0, 0, 0, 0, 0, 1, 1,
        1, 1, 0, 0, 0, 0, 0, 0, 1, 1,
        1, 1, 0, 0, 0, 0, 0, 0, 1, 1,
        1, 1, 0, 0, 0, 0, 0, 0, 1, 1,
        1, 1, 0, 0, 0, 0, 0, 0, 1, 1,
        1, 0, 1, 1, 1, 1, 1, 1, 0, 1,
        0, 1, 1, 1, 1, 1, 1, 1, 1, 0,
    ];
    
    private static const data1:Array /* of uint */ = [
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 1,
        0, 0, 0, 0, 0, 0, 0, 0, 1, 1,
        0, 0, 0, 0, 0, 0, 0, 0, 1, 1,
        0, 0, 0, 0, 0, 0, 0, 0, 1, 1,
        0, 0, 0, 0, 0, 0, 0, 0, 1, 1,
        0, 0, 0, 0, 0, 0, 0, 0, 1, 1,
        0, 0, 0, 0, 0, 0, 0, 0, 1, 1,
        0, 0, 0, 0, 0, 0, 0, 0, 1, 1,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 1,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 1,
        0, 0, 0, 0, 0, 0, 0, 0, 1, 1,
        0, 0, 0, 0, 0, 0, 0, 0, 1, 1,
        0, 0, 0, 0, 0, 0, 0, 0, 1, 1,
        0, 0, 0, 0, 0, 0, 0, 0, 1, 1,
        0, 0, 0, 0, 0, 0, 0, 0, 1, 1,
        0, 0, 0, 0, 0, 0, 0, 0, 1, 1,
        0, 0, 0, 0, 0, 0, 0, 0, 1, 1,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 1,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    ];
    
    private static const data2:Array /* of uint */ = [
        0, 1, 1, 1, 1, 1, 1, 1, 1, 0,
        0, 0, 1, 1, 1, 1, 1, 1, 0, 1,
        0, 0, 0, 0, 0, 0, 0, 0, 1, 1,
        0, 0, 0, 0, 0, 0, 0, 0, 1, 1,
        0, 0, 0, 0, 0, 0, 0, 0, 1, 1,
        0, 0, 0, 0, 0, 0, 0, 0, 1, 1,
        0, 0, 0, 0, 0, 0, 0, 0, 1, 1,
        0, 0, 0, 0, 0, 0, 0, 0, 1, 1,
        0, 0, 0, 0, 0, 0, 0, 0, 1, 1,
        0, 0, 1, 1, 1, 1, 1, 1, 0, 1,
        0, 1, 1, 1, 1, 1, 1, 1, 1, 0,
        1, 0, 1, 1, 1, 1, 1, 1, 0, 0,
        1, 1, 0, 0, 0, 0, 0, 0, 0, 0,
        1, 1, 0, 0, 0, 0, 0, 0, 0, 0,
        1, 1, 0, 0, 0, 0, 0, 0, 0, 0,
        1, 1, 0, 0, 0, 0, 0, 0, 0, 0,
        1, 1, 0, 0, 0, 0, 0, 0, 0, 0,
        1, 1, 0, 0, 0, 0, 0, 0, 0, 0,
        1, 1, 0, 0, 0, 0, 0, 0, 0, 0,
        1, 0, 1, 1, 1, 1, 1, 1, 0, 0,
        0, 1, 1, 1, 1, 1, 1, 1, 1, 0,
    ];
    
    private static const data3:Array /* of uint */ = [
        0, 1, 1, 1, 1, 1, 1, 1, 1, 0,
        0, 0, 1, 1, 1, 1, 1, 1, 0, 1,
        0, 0, 0, 0, 0, 0, 0, 0, 1, 1,
        0, 0, 0, 0, 0, 0, 0, 0, 1, 1,
        0, 0, 0, 0, 0, 0, 0, 0, 1, 1,
        0, 0, 0, 0, 0, 0, 0, 0, 1, 1,
        0, 0, 0, 0, 0, 0, 0, 0, 1, 1,
        0, 0, 0, 0, 0, 0, 0, 0, 1, 1,
        0, 0, 0, 0, 0, 0, 0, 0, 1, 1,
        0, 0, 1, 1, 1, 1, 1, 1, 0, 1,
        0, 1, 1, 1, 1, 1, 1, 1, 1, 0,
        0, 0, 1, 1, 1, 1, 1, 1, 0, 1,
        0, 0, 0, 0, 0, 0, 0, 0, 1, 1,
        0, 0, 0, 0, 0, 0, 0, 0, 1, 1,
        0, 0, 0, 0, 0, 0, 0, 0, 1, 1,
        0, 0, 0, 0, 0, 0, 0, 0, 1, 1,
        0, 0, 0, 0, 0, 0, 0, 0, 1, 1,
        0, 0, 0, 0, 0, 0, 0, 0, 1, 1,
        0, 0, 0, 0, 0, 0, 0, 0, 1, 1,
        0, 0, 1, 1, 1, 1, 1, 1, 0, 1,
        0, 1, 1, 1, 1, 1, 1, 1, 1, 0,
    ];
    
    private static const data4:Array /* of uint */ = [
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        1, 0, 0, 0, 0, 0, 0, 0, 0, 1,
        1, 1, 0, 0, 0, 0, 0, 0, 1, 1,
        1, 1, 0, 0, 0, 0, 0, 0, 1, 1,
        1, 1, 0, 0, 0, 0, 0, 0, 1, 1,
        1, 1, 0, 0, 0, 0, 0, 0, 1, 1,
        1, 1, 0, 0, 0, 0, 0, 0, 1, 1,
        1, 1, 0, 0, 0, 0, 0, 0, 1, 1,
        1, 1, 0, 0, 0, 0, 0, 0, 1, 1,
        1, 0, 1, 1, 1, 1, 1, 1, 0, 1,
        0, 1, 1, 1, 1, 1, 1, 1, 1, 0,
        0, 0, 1, 1, 1, 1, 1, 1, 0, 1,
        0, 0, 0, 0, 0, 0, 0, 0, 1, 1,
        0, 0, 0, 0, 0, 0, 0, 0, 1, 1,
        0, 0, 0, 0, 0, 0, 0, 0, 1, 1,
        0, 0, 0, 0, 0, 0, 0, 0, 1, 1,
        0, 0, 0, 0, 0, 0, 0, 0, 1, 1,
        0, 0, 0, 0, 0, 0, 0, 0, 1, 1,
        0, 0, 0, 0, 0, 0, 0, 0, 1, 1,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 1,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    ];
    
    private static const data5:Array /* of uint */ = [
        0, 1, 1, 1, 1, 1, 1, 1, 1, 0,
        1, 0, 1, 1, 1, 1, 1, 1, 0, 0,
        1, 1, 0, 0, 0, 0, 0, 0, 0, 0,
        1, 1, 0, 0, 0, 0, 0, 0, 0, 0,
        1, 1, 0, 0, 0, 0, 0, 0, 0, 0,
        1, 1, 0, 0, 0, 0, 0, 0, 0, 0,
        1, 1, 0, 0, 0, 0, 0, 0, 0, 0,
        1, 1, 0, 0, 0, 0, 0, 0, 0, 0,
        1, 1, 0, 0, 0, 0, 0, 0, 0, 0,
        1, 0, 1, 1, 1, 1, 1, 1, 0, 0,
        0, 1, 1, 1, 1, 1, 1, 1, 1, 0,
        0, 0, 1, 1, 1, 1, 1, 1, 0, 1,
        0, 0, 0, 0, 0, 0, 0, 0, 1, 1,
        0, 0, 0, 0, 0, 0, 0, 0, 1, 1,
        0, 0, 0, 0, 0, 0, 0, 0, 1, 1,
        0, 0, 0, 0, 0, 0, 0, 0, 1, 1,
        0, 0, 0, 0, 0, 0, 0, 0, 1, 1,
        0, 0, 0, 0, 0, 0, 0, 0, 1, 1,
        0, 0, 0, 0, 0, 0, 0, 0, 1, 1,
        0, 0, 1, 1, 1, 1, 1, 1, 0, 1,
        0, 1, 1, 1, 1, 1, 1, 1, 1, 0,
    ];
    
    private static const data6:Array /* of uint */ = [
        0, 1, 1, 1, 1, 1, 1, 1, 1, 0,
        1, 0, 1, 1, 1, 1, 1, 1, 0, 0,
        1, 1, 0, 0, 0, 0, 0, 0, 0, 0,
        1, 1, 0, 0, 0, 0, 0, 0, 0, 0,
        1, 1, 0, 0, 0, 0, 0, 0, 0, 0,
        1, 1, 0, 0, 0, 0, 0, 0, 0, 0,
        1, 1, 0, 0, 0, 0, 0, 0, 0, 0,
        1, 1, 0, 0, 0, 0, 0, 0, 0, 0,
        1, 1, 0, 0, 0, 0, 0, 0, 0, 0,
        1, 0, 1, 1, 1, 1, 1, 1, 0, 0,
        0, 1, 1, 1, 1, 1, 1, 1, 1, 0,
        1, 0, 1, 1, 1, 1, 1, 1, 0, 1,
        1, 1, 0, 0, 0, 0, 0, 0, 1, 1,
        1, 1, 0, 0, 0, 0, 0, 0, 1, 1,
        1, 1, 0, 0, 0, 0, 0, 0, 1, 1,
        1, 1, 0, 0, 0, 0, 0, 0, 1, 1,
        1, 1, 0, 0, 0, 0, 0, 0, 1, 1,
        1, 1, 0, 0, 0, 0, 0, 0, 1, 1,
        1, 1, 0, 0, 0, 0, 0, 0, 1, 1,
        1, 0, 1, 1, 1, 1, 1, 1, 0, 1,
        0, 1, 1, 1, 1, 1, 1, 1, 1, 0,
    ];
    
    private static const data7:Array /* of uint */ = [
        0, 1, 1, 1, 1, 1, 1, 1, 1, 0,
        1, 0, 1, 1, 1, 1, 1, 1, 0, 1,
        1, 1, 0, 0, 0, 0, 0, 0, 1, 1,
        1, 1, 0, 0, 0, 0, 0, 0, 1, 1,
        1, 1, 0, 0, 0, 0, 0, 0, 1, 1,
        1, 1, 0, 0, 0, 0, 0, 0, 1, 1,
        1, 1, 0, 0, 0, 0, 0, 0, 1, 1,
        1, 1, 0, 0, 0, 0, 0, 0, 1, 1,
        1, 1, 0, 0, 0, 0, 0, 0, 1, 1,
        1, 0, 0, 0, 0, 0, 0, 0, 0, 1,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 1,
        0, 0, 0, 0, 0, 0, 0, 0, 1, 1,
        0, 0, 0, 0, 0, 0, 0, 0, 1, 1,
        0, 0, 0, 0, 0, 0, 0, 0, 1, 1,
        0, 0, 0, 0, 0, 0, 0, 0, 1, 1,
        0, 0, 0, 0, 0, 0, 0, 0, 1, 1,
        0, 0, 0, 0, 0, 0, 0, 0, 1, 1,
        0, 0, 0, 0, 0, 0, 0, 0, 1, 1,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 1,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    ];
    
    private static const data8:Array /* of uint */ = [
        0, 1, 1, 1, 1, 1, 1, 1, 1, 0,
        1, 0, 1, 1, 1, 1, 1, 1, 0, 1,
        1, 1, 0, 0, 0, 0, 0, 0, 1, 1,
        1, 1, 0, 0, 0, 0, 0, 0, 1, 1,
        1, 1, 0, 0, 0, 0, 0, 0, 1, 1,
        1, 1, 0, 0, 0, 0, 0, 0, 1, 1,
        1, 1, 0, 0, 0, 0, 0, 0, 1, 1,
        1, 1, 0, 0, 0, 0, 0, 0, 1, 1,
        1, 1, 0, 0, 0, 0, 0, 0, 1, 1,
        1, 0, 1, 1, 1, 1, 1, 1, 0, 1,
        0, 1, 1, 1, 1, 1, 1, 1, 1, 0,
        1, 0, 1, 1, 1, 1, 1, 1, 0, 1,
        1, 1, 0, 0, 0, 0, 0, 0, 1, 1,
        1, 1, 0, 0, 0, 0, 0, 0, 1, 1,
        1, 1, 0, 0, 0, 0, 0, 0, 1, 1,
        1, 1, 0, 0, 0, 0, 0, 0, 1, 1,
        1, 1, 0, 0, 0, 0, 0, 0, 1, 1,
        1, 1, 0, 0, 0, 0, 0, 0, 1, 1,
        1, 1, 0, 0, 0, 0, 0, 0, 1, 1,
        1, 0, 1, 1, 1, 1, 1, 1, 0, 1,
        0, 1, 1, 1, 1, 1, 1, 1, 1, 0,
    ];
    
    private static const data9:Array /* of uint */ = [
        0, 1, 1, 1, 1, 1, 1, 1, 1, 0,
        1, 0, 1, 1, 1, 1, 1, 1, 0, 1,
        1, 1, 0, 0, 0, 0, 0, 0, 1, 1,
        1, 1, 0, 0, 0, 0, 0, 0, 1, 1,
        1, 1, 0, 0, 0, 0, 0, 0, 1, 1,
        1, 1, 0, 0, 0, 0, 0, 0, 1, 1,
        1, 1, 0, 0, 0, 0, 0, 0, 1, 1,
        1, 1, 0, 0, 0, 0, 0, 0, 1, 1,
        1, 1, 0, 0, 0, 0, 0, 0, 1, 1,
        1, 0, 1, 1, 1, 1, 1, 1, 0, 1,
        0, 1, 1, 1, 1, 1, 1, 1, 1, 0,
        0, 0, 1, 1, 1, 1, 1, 1, 0, 1,
        0, 0, 0, 0, 0, 0, 0, 0, 1, 1,
        0, 0, 0, 0, 0, 0, 0, 0, 1, 1,
        0, 0, 0, 0, 0, 0, 0, 0, 1, 1,
        0, 0, 0, 0, 0, 0, 0, 0, 1, 1,
        0, 0, 0, 0, 0, 0, 0, 0, 1, 1,
        0, 0, 0, 0, 0, 0, 0, 0, 1, 1,
        0, 0, 0, 0, 0, 0, 0, 0, 1, 1,
        0, 0, 1, 1, 1, 1, 1, 1, 0, 1,
        0, 1, 1, 1, 1, 1, 1, 1, 1, 0,
    ];
    
    public static const data:Array /* of Array */ = [
        data0, data1, data2, data3, data4, data5, data6, data7, data8, data9
    ];
}
