/**
 * Copyright fumix ( http://wonderfl.net/user/fumix )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/cogr
 */

package {
    import flash.events.*;
    import org.papervision3d.materials.*;
    import org.papervision3d.objects.primitives.*;
    import org.papervision3d.objects.*;
    import org.papervision3d.view.*;
    // DisplayObject3DSample クラス
    public class DisplayObject3DSample extends BasicView {
        
        private var wrap:DisplayObject3D;// 親
        private var objList:Array;
        
        public function DisplayObject3DSample() {
            // 親を作成
            wrap = new DisplayObject3D();
            objList = new Array();
            // 親をシーンに追加
            scene.addChild(wrap);
            
            // マテリアルを作成
            var material:WireframeMaterial = new WireframeMaterial(0x3399FF);
            material.doubleSided = true;
            
            var max:int = 10; // 平面を10個作成
            
            for(var i:int = 0; i < max; i++){
                // 平面を作成
                var obj:Plane = new Plane(material, 200, 200);
                objList.push(obj);
                //配置すべき角度を計算
                var rot:Number = 360 * (i / max);
                
                // 平面を円周上に配置
                obj.x = 600 * Math.sin(rot * Math.PI / 180);
                obj.z = 600 * Math.cos(rot * Math.PI / 180);
                //obj.lookAt(DisplayObject3D.ZERO); //原点方向を向かせる
                //obj.addEventListener(Event.ENTER_FRAME, loop2);
                // 親に平面を追加
                wrap.addChild(obj);
            }
            
            // レンダリング
            startRendering();
            addEventListener(Event.ENTER_FRAME, loop);
        }
        
        private function loop(e:Event):void{
            // 親をY軸方向に回転させる
            wrap.rotationY += 1;
             var max:int = 10; // 平面を10個作成
            for(var i in objList){
                // 平面を作成
                var obj:Plane = objList[i];
                obj.rotationY -= 1;
            }
       }
        private function loop2(e:Event):void{
            // 親をY軸方向に回転させる
            e.target.yaw(-wrap.rotationY);
        }
    }
}