/**
 * Copyright matsumos ( http://wonderfl.net/user/matsumos )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/cniJ
 */

// forked from clockmaker's [BetweenAS3]delayの検証
/**
* BetweenAS3の遅延使用時における動作検証
* 同一オブジェクトに複数の遅延トゥイーンを設定した場合、
* ２番目以降のトゥイーンで第３引数をnullにすると挙動が怪しいかも…
*
* Test Aではserialを利用。serial利用時には問題はない。
* Test Bで、Ballが右側にいったときに、x座標が0になる
*/
package {
    import flash.display.*;
    import flash.events.*
    import org.libspark.betweenas3.BetweenAS3;
    import org.libspark.betweenas3.easing.*;
    import com.bit101.components.*;

    public class FlashTest extends Sprite {
        private var ball:Sprite;
        public function FlashTest() {
            
            ball = createBall();
            ball.y = 100;
            addChild(ball);
            
            new PushButton(this, 10, 300, "x = 0", function():void{ball.x = 0});
            new PushButton(this, 10, 330, "x = 100", function():void{ball.x = 100});
            new PushButton(this, 120, 300, "Test A", testA);
            new PushButton(this, 230, 300, "Test B", testB);
            new PushButton(this, 340, 300, "Test C", testC);
        }
        
        private function testA(e:Event):void {
            BetweenAS3.serial(
                BetweenAS3.delay(
                    BetweenAS3.tween(ball, {x:300}, {x:0}, 1, Expo.easeInOut),
                    0.5),
                
                BetweenAS3.delay(
                    BetweenAS3.tween(ball, {x:100}, null, 2, Expo.easeInOut),
                    1)
                ).play();
        }
        
        
        private function testB(e:Event):void {
            BetweenAS3.delay(
                BetweenAS3.tween(ball, {x:300}, {x:0}, 2, Expo.easeInOut),
                0.5).play();
                
            BetweenAS3.delay(
                BetweenAS3.tween(ball, {x:100}, null, 2, Expo.easeInOut),
                4).play();
            
            BetweenAS3.delay(
                BetweenAS3.delay(
                    BetweenAS3.tween(ball, {x:100}, null, 2, Expo.easeInOut),
                    6),
                2).play();
        }
        
        private function testC(e:Event):void {
            BetweenAS3.delay(
                BetweenAS3.to(ball, {x:300}, 2, Expo.easeInOut),
                0.5).play();
                
            BetweenAS3.delay(
                BetweenAS3.to(ball, {x:100}, 2, Expo.easeInOut),
                4).play();
                
            BetweenAS3.delay(    
                BetweenAS3.delay(
                    BetweenAS3.to(ball, {x:100}, 2, Expo.easeInOut),
                    6),
                2).play();
        }
        
        private function createBall():Sprite{
            var ball:Sprite = new Sprite();
            ball.graphics.beginFill(0xFF0000);
            ball.graphics.drawCircle(0,0,100);
            return ball;
        }
    }
}