/**
 * Copyright naokey0221 ( http://wonderfl.net/user/naokey0221 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/cndl
 */

// forked from clockmaker's [PV3D] サンプル2 (3Dのアニメーション) 
package {
    import flash.events.Event;
    import flash.events.MouseEvent;
    import org.papervision3d.materials.WireframeMaterial;
    import org.papervision3d.objects.primitives.*;
    import org.papervision3d.view.BasicView;
    
    public class Sample2 extends BasicView {
       private var isMouseDown:Boolean = false; // マウスを押してるかのフラグ
        private var sphere:Sphere; // 球面のインスタンス
        public function Sample2():void {
            // マテリアルを作成
            var material:WireframeMaterial = new WireframeMaterial(0xFF0000);
            
            // 3Dオブジェクトを作成
            sphere = new Sphere(material, 300, 20, 10);
            
            // 3Dシーンに追加して、表示させる
            scene.addChild(sphere);
            
            // レンダリングを開始
            startRendering();
            
            // エンターフレームを設定
            addEventListener(Event.ENTER_FRAME, loop);
            stage.addEventListener(MouseEvent.MOUSE_DOWN, downHandler);
            stage.addEventListener(MouseEvent.MOUSE_UP, upHandler);
        }
        
        private function loop(e:Event):void {
            // 球面をY軸方向に回転
            sphere.rotationY += 10;
            if(isMouseDown){
            sphere.x = mouseX - viewport.width / 2;
            sphere.y = -(mouseY - viewport.height / 2);
            } 
                    
        }
       private function upHandler(e:MouseEvent):void {
            isMouseDown = false;
        }

        private function downHandler(e:MouseEvent):void {
            isMouseDown = true;
        }
        
    }
}