/**
 * Copyright christian ( http://wonderfl.net/user/christian )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/cncT
 */

package
{
    import flash.display.*;
    import flash.events.Event;
    import com.bit101.components.*;

    /* @author SPANVEGA // CHRISTIAN */

    [ SWF (width = '465', height = '465', backgroundColor = '0xFFFFFF', frameRate = '30')]

    public class MIRAGE extends Sprite
    {
        private var sun : SUN;

        public function MIRAGE () : void
        {
            sun = new SUN (275, 275);

            with (addChild (new Bitmap (sun))) { x = 50; y = 80; }

            with (new HUISlider (this, 10, 400, 'Amplitude', a))
            { labelPrecision = 2; setSliderParams (0, 0.5, sun.amplitude); }

            with (new HUISlider (this, 10, 420, 'Velocity', v))
            { labelPrecision = 2; setSliderParams (0, 5, sun.velocity); }

            with (new HUISlider (this, 10, 440, 'Multiplier', m))
            { labelPrecision = 2; setSliderParams (0, sun.maxScale, sun.multiplier); }
            
            addEventListener (Event.ENTER_FRAME, sun.render);
        }

        private function a (e : Event) : void { sun.amplitude  = e.target.value; }
        private function v (e : Event) : void { sun.velocity   = e.target.value; }
        private function m (e : Event) : void { sun.multiplier = e.target.value; }
    }
}

//

import flash.geom.*;
import flash.events.Event;
import flash.display.Shape;
import flash.display.BitmapData;

final class SUN extends BitmapData
{
    private var r : Rectangle, p : Point = new Point ();
    private var i : uint, offset : Number = 0;
    private var b : BitmapData;

    private var a : Number = 0.15;
    private var v : Number = 2.0;
    private var m : Number = 15;
    // biggest multiplier value
    private var s : int = 50; 

    private var colors : Array = [0xFF8000, 0xFFBE00, 0xFFBE00];
    private var ratios : Array = [0, 128, 255];
    private var alphas : Array = [1, 1, 0];


    public function SUN (w : uint, h : uint) : void
    {
        super (w + s * 2, h, true, 0);

        r = new Rectangle (0, 0, width, 1);

        var m : Matrix = new Matrix ();
        m.createGradientBox (w, h);

        var g : Shape = new Shape ();

        g.graphics.beginGradientFill
        (
            'radial', colors, alphas, ratios, m, 'pad', 'rgb'
        );
        g.graphics.drawRect (0, 0, w, h);

        b = new BitmapData (width, h, true, 0);

        b.draw (g, new Matrix (1, 0, 0, 1, width - g.width >> 1, 0));
    }
    
    public function render (e : Event = null) : void
    {
        fillRect (rect, 0);

        for (i = 0; i < height; i++)
        {
            p.y = r.y = i;
            p.x = Math.sin ((i + offset) * a) * m;

            copyPixels (b, r, p);
        }

        offset += v;
    }

    // setters

    public function set amplitude  (n : Number) : void { a = n; }

    public function set multiplier (n : Number) : void { m = n; }

    public function set velocity   (n : Number) : void { v = n; }

    // getters

    public function get amplitude  () : Number { return a; }

    public function get multiplier () : Number { return m; }

    public function get velocity   () : Number { return v; }

    public function get maxScale   () : Number { return s; }
}