/**
 * Copyright JohnBrookes ( http://wonderfl.net/user/JohnBrookes )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/cm4f
 */

package {
    import flash.display.AVM1Movie;
    import away3d.cameras.Camera3D;
    import away3d.containers.Scene3D;
    import away3d.containers.View3D;
    import away3d.controllers.HoverController;
    import away3d.debug.AwayStats;
    import away3d.lights.DirectionalLight;
    import away3d.materials.methods.*;
    import away3d.materials.lightpickers.StaticLightPicker;
    import away3d.primitives.*;
    import away3d.materials.*
    import away3d.entities.Mesh;
    import flash.display.Sprite;
    import flash.display.StageAlign;
    import flash.display.StageScaleMode;
    import flash.events.Event;
    import flash.events.MouseEvent;
    
    [SWF(frameRate="60")]
    public class Main extends Sprite {
        
        private var view:View3D;
        private var scene:Scene3D;
        private var camera:Camera3D;
        
        //camera controls
        private var camController:HoverController;
        private var move:Boolean = false;
        private var lastPanAngle:Number;
        private var lastTiltAngle:Number;
        private var lastMouseX:Number;
        private var lastMouseY:Number;
        
        //lights
        private var slp:StaticLightPicker;
        private var dlight:DirectionalLight;
        
        public function Main() {
            if (stage)
                init();
            else
                addEventListener(Event.ADDED_TO_STAGE, init);
        }
        
        private function init(e:Event = null):void {
            removeEventListener(Event.ADDED_TO_STAGE, init);
            // entry point
            stage.scaleMode = StageScaleMode.NO_SCALE;
            stage.align = StageAlign.TOP_LEFT;
            
            init3D();
            initLights();
            initObjects();
            initListeners();
        }
        
        private function init3D():void {
            view = new View3D();
            view.backgroundColor = 0x0;
            view.antiAlias = 8;
            scene = view.scene;
            camera = view.camera;
            addChild(view);
            
            camController = new HoverController(camera, null, 180);
            camController.tiltAngle = 45;
            camController.yFactor = 1;
            camController.steps = 32
            camController.minTiltAngle = -90
            camController.distance = 500
            
            camera.lens.far = 1000;
            
            addChild(new AwayStats(view));
        }
        
        private function initLights():void {
            dlight = new DirectionalLight(1,-1,1);
            dlight.ambient = 0.7;
            scene.addChild(dlight);
            
            slp = new StaticLightPicker([dlight]);
        }
        
        private function initObjects():void {
            var debugGrid:WireframePlane = new WireframePlane(2000, 2000, 25, 25, 0xcccccc, 1, "xz");
            scene.addChild(debugGrid);
            
            var sm:HardShadowMapMethod = new HardShadowMapMethod(dlight);
            
            var groundMat:ColorMaterial = new ColorMaterial(0xfcfcfc);
            groundMat.lightPicker = slp;
            groundMat.shadowMethod = sm;
            
            var pg:PlaneGeometry = new PlaneGeometry(1500,1500);
            var groundMesh:Mesh = new Mesh(pg, groundMat);
            scene.addChild(groundMesh);
            
            
            var cm:ColorMaterial = new ColorMaterial(0xff0000);
            cm.lightPicker = slp;
            
            var cubeGeom:CubeGeometry = new CubeGeometry(100,100,100);
            
            var mesh:Mesh  = new Mesh(cubeGeom, cm);
            mesh.y = 50;
            scene.addChild(mesh);
            
            var mesh2:Mesh = new Mesh(cubeGeom,cm);
            scene.addChild(mesh2);
            mesh2.y = 100;
            mesh2.z = 400;
            mesh2.scale(2);
            
        }
        
        private function handleEnterFrame(e:Event):void {
            if (move) {
                camController.panAngle = 0.3 * (stage.mouseX - lastMouseX) + lastPanAngle;
                camController.tiltAngle = 0.3 * (stage.mouseY - lastMouseY) + lastTiltAngle;
            }
            
            //dlight.direction = view.camera.forwardVector;
            view.render();
        }
        
        private function onMouseDown(event:MouseEvent):void {
            lastPanAngle = camController.panAngle;
            lastTiltAngle = camController.tiltAngle;
            lastMouseX = stage.mouseX;
            lastMouseY = stage.mouseY;
            move = true;
            stage.addEventListener(Event.MOUSE_LEAVE, onStageMouseLeave);
        }
        
        /**
         * Mouse up listener for navigation
         */
        private function onMouseUp(event:MouseEvent):void {
            move = false;
            stage.removeEventListener(Event.MOUSE_LEAVE, onStageMouseLeave);
        }
        
        private function onMouseWheel(event:MouseEvent):void {
            camController.distance -= event.delta * 10;
        }
        
        /**
         * Mouse stage leave listener for navigation
         */
        private function onStageMouseLeave(event:Event):void {
            move = false;
            stage.removeEventListener(Event.MOUSE_LEAVE, onStageMouseLeave);
        }
        
        private function onStageResize(event:Event):void {
            view.width = stage.stageWidth;
            view.height = stage.stageHeight;
        }
        
        private function initListeners():void {
            addEventListener(Event.ENTER_FRAME, handleEnterFrame);
            stage.addEventListener(Event.RESIZE, onStageResize);
            stage.addEventListener(MouseEvent.MOUSE_DOWN, onMouseDown);
            stage.addEventListener(MouseEvent.MOUSE_UP, onMouseUp);
            stage.addEventListener(MouseEvent.MOUSE_WHEEL, onMouseWheel);
        }
    }
}