/**
 * Copyright nki2 ( http://wonderfl.net/user/nki2 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/cleh
 */

// forked from yanbaka's HANABI
// 色々参考にさせて頂いてます
// COMETにしてみました...
package
{
	import flash.display.Bitmap;
	import flash.display.BitmapData;
	import flash.display.BlendMode;
	import flash.display.PixelSnapping;
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.events.TimerEvent;
	import flash.filters.BlurFilter;
	import flash.geom.ColorTransform;
	import flash.geom.Matrix;
	import flash.geom.Point;
	import flash.geom.Rectangle;
	import flash.utils.Timer;
	[SWF(width = "465", height = "465", backgroundColor = "0x000000", frameRate = "30")]
	
	public class Hanabi extends Sprite
	{
		private const WIDTH:Number = 465;
		private const HEIGH:Number = 465;
		
		private var _particles:Array;
		private var _canvas:BitmapData;
		private var _glow:BitmapData;
		private var _rect:Rectangle;
		private var cTra:ColorTransform;
		private var timer:Timer;
		
		private var sx:Number;
		private var sy:Number;
		
		
		public function Hanabi()
		{
			init();
		}
		
		private function init():void
		{
			_particles = [];
			_canvas = new BitmapData(WIDTH, HEIGH, false, 0x0);
			addChild(new Bitmap(_canvas)) as Bitmap;
			
			_glow = new BitmapData(WIDTH/4, HEIGH/4, false, 0x0);
			var bm:Bitmap = addChild(new Bitmap(_glow, PixelSnapping.NEVER, true)) as Bitmap;
			bm.scaleX = bm.scaleY = 4;
			bm.blendMode = BlendMode.ADD;
			
			_rect = new Rectangle(0, 0, WIDTH, HEIGH);
			cTra = new ColorTransform(0.8, 0.8, 0.9, 1);
			
			this.stage.addEventListener(Event.ENTER_FRAME, enterframeHandler);
			
			timer = new Timer(100);
			timer.addEventListener(TimerEvent.TIMER, resetFunc);
			timer.start();
		}
		
		private function resetFunc(e:TimerEvent):void
		{
			(cTra.redMultiplier > 0.9)? cTra.redMultiplier = 0.8 : cTra.redMultiplier += 0.01;
			
			hanabi();
		}
		
		private function hanabi():void 
		{
			var i:int = 180;
			sx = WIDTH * 0.20;
			sy = HEIGH * 0.80;
			while (i--) createParticle();
		}
		
		private function createParticle():void {
			var p:Particle = new Particle();
			p.x = sx;
			p.y = sy;
			var radius:Number = Math.sqrt(Math.random())*4;
			var angle:Number = Math.random()*(Math.PI)*2;
			p.vx = Math.cos(angle) * radius;
			p.vy = Math.sin(angle) * radius;
			_particles.push(p);
		}
		
		private function enterframeHandler(e:Event):void
		{
			update();
		}
		
		private function update():void {
			_canvas.lock();
			_canvas.applyFilter(_canvas, _rect, new Point(), new BlurFilter(2, 2));
			_canvas.colorTransform(_rect, cTra);
			var i:int = _particles.length;
			while (i--) {
				var p:Particle = _particles[i];
				p.vx += 0.6;
				p.vy -= 0.3;
				p.vx *= 0.96;
				p.vy *= 0.96;
				p.x += p.vx;
				p.y += p.vy;
				_canvas.setPixel32(p.x, p.y, p.c);
				if ((p.x > stage.stageWidth || p.x < 0) || (p.y < 0 || p.y > stage.stageHeight) || Math.abs(p.vx) < .01 || Math.abs(p.vy) < .01)
				{
					this._particles.splice(i, 1);
				}
			}
			_canvas.unlock();
                        var mat:Matrix = new Matrix();
                        mat.scale(0.25, 0.25);
			_glow.draw(_canvas, mat);
		}
	}
}

class Particle
{
	public var x:Number;
	public var y:Number;
	public var vx:Number;
	public var vy:Number;
	public var c:uint;
	
	public function Particle()
	{
		this.x = 0;
		this.y = 0;
		this.vx = 0;
		this.vy = 0;
		this.c = 0xFFFFFFFF;
	}
}

