/**
 * Copyright hirose_golf ( http://wonderfl.net/user/hirose_golf )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/cl88
 */

// forked from Dorara's first flash practice - 1hour othello
// flash始めた記念othello(1時間でversion)
// コンピュータ戦はまた今度。flash楽しいね！
//                   2009.10.4
// 追記: 置き直す所がバグってたのでbreakを追加。(2009.10.5)
//       && 222行に直しました。(笑)
package {
    import flash.display.Sprite;
    import flash.display.StageAlign;
    import flash.display.StageScaleMode;
    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.text.TextField;


    [SWF(backgroundColor=0x000000)]
    public class Othello extends Sprite
    {    
        private var Field:Array;
        private var Koma:Array;
        private var turn:int;
        private var text:TextField;
        
        public function Othello()
        {
            this.stage.scaleMode = StageScaleMode.NO_SCALE;
            this.stage.align = StageAlign.TOP_LEFT;
            
            Field = new Array(8)
            for(var i:int = 0; i < 8; i++)
            {
                var tmp:Array = new Array(8);
                Field[i] = tmp;
                for(var j:int = 0; j < 8; j++)
                {
                    Field[i][j] = 0;
                }
            }
            Field[3][3] = 2; Field[3][4] = 1;
            Field[4][3] = 1; Field[4][4] = 2;
            turn = 1; //最初は黒
            showBoard(); //下のボードの表示
            initKoma(); //コマを表示(何もない所は緑のコマを置いてる!!?)
            
            //textFieldの表示
            text = new TextField();
            text.background = true;
            text.backgroundColor = 0xffffff;
            text.text = "";
            text.x = 280;
            text.y = 0;
            text.width = 150;
            text.height = 50;
            this.addChild(text);
    
            showKoma(); //コマの表示
        }
        
        //盤面の表示
        public function showBoard():void
        {
            for(var i:int = 0; i < 8; i++)
            {
                for(var j:int = 0; j < 8; j++)
                {
                    var cell:Sprite = new Sprite();
                    cell.graphics.beginFill(0x00ee00);
                    cell.graphics.drawRect(0,0,33,33);
                    cell.graphics.endFill();
                    cell.x = j * 34;
                    cell.y = i * 34;
                    cell.addEventListener(MouseEvent.CLICK, onClick);
                    this.addChild(cell);        
                }
            }
        }
        
        //コマを配置
        public function initKoma():void
        {
            Koma = new Array(8);
            for(var i:int = 0; i < 8; i++)
            {
                var tmp:Array;
                tmp = new Array(8);
                Koma[i] = tmp;
                for(var j:int = 0; j < 8; j++)
                {
                    var cell:Sprite = new Sprite();
                    cell.graphics.beginFill(0x000000);
                    cell.graphics.drawCircle(16,16,15);
                    cell.graphics.endFill();
                    cell.x = j * 34;
                    cell.y = i * 34;
                    cell.addEventListener(MouseEvent.CLICK, onClick);
                    Koma[i][j] = cell;
                    this.addChild(cell);
                }
            }
        }
        
        //Fieldの値からコマを表示しなおす
        public function showKoma():void
        {
            for(var i:int = 0; i < 8; i++)
            {
                for(var j:int = 0; j < 8; j++)
                {
                    if(Field[i][j] == 0 && canPut(i,j)) //何もなし
                    {
                        Koma[i][j].graphics.beginFill(0xee0000);
                        Koma[i][j].graphics.drawCircle(16,16,15);
                        Koma[i][j].graphics.endFill();
                    }
                    else if(Field[i][j] == 0) //何もなし
                    {
                        Koma[i][j].graphics.beginFill(0x00ee00);
                        Koma[i][j].graphics.drawCircle(16,16,15);
                        Koma[i][j].graphics.endFill();
                    }
                    else if(Field[i][j] == 1) //黒
                    {
                        Koma[i][j].graphics.beginFill(0x000000);
                        Koma[i][j].graphics.drawCircle(16,16,15);
                        Koma[i][j].graphics.endFill();
                    }
                    else //白
                    {
                        Koma[i][j].graphics.beginFill(0xffffff);
                        Koma[i][j].graphics.drawCircle(16,16,15);
                        Koma[i][j].graphics.endFill();
                    }
                }
            }
            if(turn == 1) text.text = "Black's turn";
            if(turn == 2) text.text = "White's turn";
        }
        
        public function showKoma2():void
        {
            for(var i:int = 0; i < 8; i++)
            {
                for(var j:int = 0; j < 8; j++)
                {
                    if(Field[i][j] == 0 && canPut(i,j)) //何もなし
                    {
                        Koma[i][j].graphics.beginFill(0xee0000);
                        Koma[i][j].graphics.drawCircle(16,16,15);
                        Koma[i][j].graphics.endFill();
                    }
                }
            }
        }
        
        
        
        //マウスで押されたところが空なら置く
        public function onClick(e:Event):void
        {
            var _x:int = stage.mouseX/34; //e.target.x/34;
            var _y:int = stage.mouseY/34; //e.target.y/34;
            if(Field[_y][_x] == 0)
            {
                if(canPut(_x,_y))
                {
                    changeKoma(_x,_y);
                    turn = 3 - turn;
                    showKoma();
                    //showKoma2();
                    //置いた後に、その次の人がパスかどうかチェック
                    if(passCheck() == false)
                    {
                        trace("turn" + turn + "is pass");
                        if(turn == 1) text.text = "Black is PASS!!!\nWhite's turn";
                        if(turn == 2) text.text = "White is PASS!!!\nBlack's turn"; 
                        //ついでに自分も置けなくなったら終了
                        turn = 3 - turn;
                        if(passCheck() == false)
                        {
                            trace("Finish.");
                            text.text = "Finish!!";
                        }
                    }
                }
            }
        }
        
        //範囲内かどうかチェック
        public function inrange(x:int, y:int):Boolean
        {
            if(0<=x && x<=7 && 0<=y && y<=7) return true;
            return false;
        }
        
        //置けるかチェック
        public function canPut(x:int, y:int):Boolean
        {
            for(var dy:int    = -1; dy <= 1; dy++)
            {
                for(var dx:int = -1; dx <= 1; dx++)
                {
                    var _x:int = x + dx;
                    var _y:int = y + dy;
                    if(inrange(_x,_y))
                    {
                        if(Field[_y][_x] == 3 - turn)
                        {
                            _x += dx; _y += dy;
                            while(inrange(_x,_y))
                            {
                                if(Field[_y][_x] == 0) break;
                                else if(Field[_y][_x] == turn) return true; 
                                _x += dx;
                                _y += dy;
                            }
                        }
                    }
                }
            }
            return false;
        }
        
        //コマを置き換える
        public function changeKoma(x:int, y:int):void
        {
            Field[y][x] = turn;
            for(var dy:int    = -1; dy <= 1; dy++)
            {
                for(var dx:int = -1; dx <= 1; dx++)
                {
                    var _x:int = x + dx;
                    var _y:int = y + dy;
                    if(inrange(_x,_y))
                    {
                        if(Field[_y][_x] == 3 - turn)
                        {
                            _x += dx; _y += dy;
                            while(inrange(_x,_y))
                            {
                                if(Field[_y][_x] == 0) break;
                                else if(Field[_y][_x] == turn)
                                {
                                    var _tx:int = x, _ty:int = y;
                                    while(_tx != _x || _ty != _y)
                                    {
                                        Field[_ty][_tx] = turn;
                                        _tx += dx;
                                        _ty += dy;
                                    }
                                    break;
                                } 
                                _x += dx;
                                _y += dy;
                            }
                        }
                    }
                }
            }
        }
        
        //パスかどうかのチェック
        public function passCheck():Boolean
        {
            var ret:Boolean = false;
            for(var y:int = 0; y < 8; y++)
            {
                for(var x:int = 0 ; x < 8; x++)
                {
                    if(Field[y][x] == 0)
                    {
                        if(canPut(x, y)) ret = true;
                    }
                }
            }
            return ret;
        }

    }
}
