/**
 * Copyright hrtsgt ( http://wonderfl.net/user/hrtsgt )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/ckqK
 */

package
{
    import com.bit101.components.Label;
    import com.bit101.components.PushButton;
    
    import flash.display.Sprite;
    import flash.events.*;

    [SWF(width=465, height=465, frameRate=60)]
    
    public class TypePunch extends Sprite
    {
        public const LABEL:String = 'Quick brown fox jumps over the lazy dog.';
        public const A:int = 33;
        public const B:int = 126;
        
        private var _label:Label;
        private var _onOff:PushButton;
        private var _type:PushButton;
        
        private var o:Boolean;
        private var t:Boolean;
        private var p:int;
        
        public function TypePunch()
        {
            if( stage ) init();
            else this.addEventListener( Event.ADDED_TO_STAGE, init);
        }
        
        private function init( e:Event=null ):void
        {
            if( e ) this.removeEventListener( Event.ADDED_TO_STAGE, init);//
            _label = new Label( this, 50, 215 );
            _label.scaleX = _label.scaleY = 2;
            _onOff = new PushButton(this, 50, 15, 'PUNCH', onPush);
            _type = new PushButton( this, 155, 15, 'TRANSITION TYPE', onType);
            _onOff.toggle = _type.toggle = true;
        }
        
        /** ON/OFF */
        private function onPush( e:MouseEvent ):void
        {
            o = _onOff.selected;
            if( !o && !t ) p = LABEL.length;
            this.addEventListener( Event.ENTER_FRAME, update);//
        }
        /** Transiiton Type */
        private function onType( e:MouseEvent ):void
        {
            t = _type.selected;
        }
        
        /** ENTER_FRAME */
        private function update( e:Event ):void
        {
            var str:String;
            if( o )
            {
                str = LABEL.substr(0, p);
                if( t ) str += getRandomChar() + '-';
                else for(var i:int=p; i<LABEL.length; i++) str += getRandomChar();
                if( ++p >= LABEL.length )
                {
                    str = LABEL;
                    this.removeEventListener( Event.ENTER_FRAME, update);//
                }
            }else{
                str = _label.text.substr(0, --p)
                str += t ?  '_' : getRandomChar();
                if( p <= 0 )
                {
                    str = '';
                    this.removeEventListener( Event.ENTER_FRAME, update);
                }
            }
            _label.text = str;
        }
        
        /** return randomized character */
        private function getRandomChar( _a:int=33, _b:int=126):String
        {
            return String.fromCharCode( int(Math.random()*(_b-_a))+_a )
        }        
        
    }
}