/**
 * Copyright kazy ( http://wonderfl.net/user/kazy )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/ckZn
 */

package {
	import flash.display.Sprite;
	import flash.events.Event;
	/**
	 * Ball
	 * ボール生成クラス.
	 */
	public class Main extends Sprite {
		private var ball:Ball;
		private var easing:Number = 0.2;
		/**
		 * コンストラクタ.
		 */
		public function Main() {
			init();
		}
		/**
		 * 初期化.
		 */
		private function init():void {
			ball = new Ball();
			addChild(ball);
			addEventListener(Event.ENTER_FRAME, onEnterFrame);
		}
		/**
		 * onEnterFrame.
		 */
		private function onEnterFrame(event:Event):void {
			var vx:Number = (mouseX - ball.x) * easing;
			var vy:Number = (mouseY - ball.y) * easing;
			ball.x += vx;
			ball.y += vy;
		}
	}
}

/**
 * Ball
 * ボール生成クラス.
 */
class Ball extends flash.display.Sprite {
	public var radius:Number;
	private var color:uint;
	public var vx:Number = 0;
	public var vy:Number = 0;
	/**
	 * コンストラクタ.
	 */
	public function Ball(radius:Number=40, color:uint=0x990033) {
		this.radius = radius;
		this.color = color;
		init();
	}
	/**
	 * 初期化.
	 */
	public function init():void {
		graphics.beginFill(color);
		graphics.drawCircle(0, 0, radius);
		graphics.endFill();
	}
}