/**
 * Copyright tepe ( http://wonderfl.net/user/tepe )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/ckB6
 */

// forked from keno42's マーカー認識のための二値化
package  
{
    import flash.display.*;
    import flash.events.*;
    import flash.geom.*;
    import flash.media.*;
    import flash.net.*;
    import flash.system.LoaderContext;
    import flash.system.Security;
    import frocessing.color.ColorHSV;
    import com.bit101.components.HUISlider;
    import com.bit101.components.Panel;
    import com.bit101.components.PushButton;
    
    public class Main extends Sprite
    {
        private var camera:Camera;
        private var video:Video;
        private var bd:BitmapData;
        
        

        private const WIDTH:int = 232;
        private const HEIGHT:int = 232;
        
        private var bitmapA:Bitmap;
        private var bitmapB:Bitmap;
        //private var bd:BitmapData;
        
        private var btn:PushButton;
        private var slider:HUISlider;
        private var panel:Panel;
        //private var valA:Number;
        private var pixelCol:uint; 
        
        private var file:FileReference = new FileReference();
 
        public function Main()
        {
            panel = new Panel(this);
            panel.width = panel.height = 465;
            
            btn = new PushButton(this,0,10,"WebCam ON");
            btn.x = 150;
            btn.y = 270;
            btn.addEventListener(MouseEvent.MOUSE_UP, startCamera);
            
            btn = new PushButton(this,0,10,"File OPEN");
            btn.x = 150;
            btn.y = 249;
            btn.addEventListener(MouseEvent.MOUSE_UP, fileOpen);
            
            Security.loadPolicyFile("http://farm3.static.flickr.com/crossdomain.xml");
            var loader:Loader = new Loader();
            loader.contentLoaderInfo.addEventListener(Event.INIT, initHandler);
            loader.load(new URLRequest("http://farm3.static.flickr.com/2133/1991035050_f169d55a13.jpg"), new LoaderContext(true));
 
            
        }
        
        private function fileOpen(e:MouseEvent):void{
            file.addEventListener(Event.SELECT,onSelect);
            file.browse();
        }
        private function onSelect(e:Event):void{
            file.removeEventListener(Event.SELECT,onSelect);
            file.addEventListener(Event.COMPLETE,onComplete);
            file.load();
        }

        
        private function onComplete(e:Event):void {
            var myLoader:Loader = new Loader();
            myLoader.loadBytes( file.data );
            myLoader.contentLoaderInfo.addEventListener( Event.INIT, initLoaded );
        }
        private function initLoaded(evt:Event):void{
           // bd = Bitmap(evt.target.content);
            var matrix:Matrix = new Matrix();
            matrix.scale(WIDTH / evt.target.width, HEIGHT / evt.target.height);
 
            bd = new BitmapData(WIDTH, HEIGHT);
            bd.draw(evt.target.content, matrix);
            
            bitmapA = new Bitmap(bd);
            panel.content.addChild(bitmapA);
            var destbd:BitmapData = bd.clone();
            bitmapB = new Bitmap(destbd);
            bitmapB.x = WIDTH + 1;
            panel.content.addChild(bitmapB);
            
            /*
            var bmp:Bitmap = Bitmap( evt.target.content );
            if(evt.target.content){
                if((bmp.width >WIDTH)||(bmp.height >HEIGHT)){
                    if( bmp.width > bmp.height){
                        var wRatio:Number = HEIGHT / bmp.width;
                        bmp.width = HEIGHT;
                        bmp.height *= wRatio;
                    } else {
                        var hRatio:Number = HEIGHT / bmp.height;
                        bmp.height = HEIGHT;
                        bmp.height *= hRatio;
                    }
                }
                
            }
            */

        }

        
        private function startCamera(e:MouseEvent):void{
            camera = Camera.getCamera();
            if ( camera == null ) {
            } else {
                start();
                stage.removeEventListener(Event.ENTER_FRAME,onFrame);
            }
            
        }

        
        private function start():void {
            camera.setMode(WIDTH,HEIGHT, 60);//カメラ設定 width, height, frame
            video = new Video(WIDTH,HEIGHT);//ビデオサイズ width, height
            video.attachCamera(camera);
            bd = new BitmapData(video.width, video.height);//ビデオサイズのビットマップデータ
            this.addChild( video );
            this.addEventListener(Event.ENTER_FRAME, onEnterFrame);
        }
        
        //毎フレーム処理
        private function onEnterFrame(e:Event):void {
            bd.lock();
            bd.draw(video);//ビデオデータ取得

            bd.unlock();
            search(bd,pixelCol,slider.value);
        }
 
        private function initHandler(event:Event):void
        {
            var loader:Loader = event.currentTarget.loader;
 
            var matrix:Matrix = new Matrix();
            matrix.scale(WIDTH / loader.width, HEIGHT / loader.height);
 
            bd = new BitmapData(WIDTH, HEIGHT);
            bd.draw(loader, matrix);
            
            bitmapA = new Bitmap(bd);
            panel.content.addChild(bitmapA);
            var destbd:BitmapData = bd.clone();
            bitmapB = new Bitmap(destbd);
            bitmapB.x = WIDTH + 1;
            panel.content.addChild(bitmapB);
            
            slider = new HUISlider(this, 5, 300, "distance");
            slider.value = 60;
            slider.minimum = 0;
            slider.maximum = 400;
            
            stage.addEventListener(MouseEvent.CLICK, onMouseClick);
            stage.addEventListener(Event.ENTER_FRAME,onFrame);
            
        }
        
        private function onFrame(event:Event):void{
                search(bd,pixelCol,slider.value);
        }

        
        private function onMouseClick(event:MouseEvent):void
        {
            if (!bitmapA.hitTestPoint(mouseX, mouseY)) return;
            bitmapB.bitmapData = bd.clone();
            
            pixelCol = bd.getPixel(mouseX, mouseY);
            search(bd,pixelCol,slider.value);
        }
        
        //カラーフィルター
        private function search( bd:BitmapData, c:int, val:Number = 50 ):void
        {    
            var colorA:ColorHSV = new ColorHSV();
            var colorB:ColorHSV = new ColorHSV();
            colorA.value = c;//基準色
            
            //ビットマップの処理
            for (var y:int = 0; y < bd.height; y++)//　Y軸
            {
                for (var x:int = 0; x < bd.width; x++)//　X軸
                {
                    colorB.value = bd.getPixel(x, y);//ピクセルの色取得
                    
                    var r:int = colorA.r - colorB.r;//赤成分
                    var g:int = colorA.g - colorB.g;//緑成分
                    var b:int = colorA.b - colorB.b;//青成分
                    //指定ピクセルの閾値判定
                    if (val < Math.sqrt(r * r + g * g + b * b)){
                        bitmapB.bitmapData.setPixel(x, y, 0xFFFFFF);
                    }
                    else{
                        bitmapB.bitmapData.setPixel(x, y, colorB.value);
                    }

                    
                }
            }
        }
        
   
        private function search2( bd:BitmapData, c:int, val:Number = 50 ):void
        {    
            var colorA:ColorHSV = new ColorHSV();
            var colorB:ColorHSV = new ColorHSV();
            colorA.value = c;//基準色
            
            //ビットマップの処理
            for (var y:int = 0; y < bd.height; y++)//　Y軸
            {
                for (var x:int = 0; x < bd.width; x++)//　X軸
                {
                    colorB.value = bd.getPixel(x, y);//ピクセルの色取得
                    
                    var r:int = colorA.r - colorB.r;//赤成分
                    var g:int = colorA.g - colorB.g;//緑成分
                    var b:int = colorA.b - colorB.b;//青成分
                    //指定ピクセルの閾値判定
                    if (val < Math.sqrt(r * r + g * g + b * b)){
                        bitmapB.bitmapData.setPixel(x, y, 0xFFFFFF);
                    }
                    else{
                        bitmapB.bitmapData.setPixel(x, y, colorB.value);
                    }

                    
                }
            }
        }
        
    }
}

