/**
 * Copyright kuroneko ( http://wonderfl.net/user/kuroneko )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/ckAG
 */

package{
	import flash.display.*;
	import flash.events.*;
	import flash.text.*;

	public class a extends Sprite{
		
		private var cells:Array;	// cell array
		private var coidx:Array;	// color index
		private var color:Array;
		private var palle:Array;
		private var scidx:int=0;	// selected color index
		private var _flag:int=0;	// 0:mouse up, 1:mouse dn
		private var tf:TextField;
		
		private var __h:int=32;
		private var __w:int=32;
		private var __s:int=8;
		
		private var cchrt:Array;	// color chart
		
		public function a():void{
			cells=new Array();
			coidx=new Array();
			color=new Array();
			palle=new Array();
			tf=new TextField();
			tf.x=0;tf.y=300;
			tf.text="test";
			addChild(tf);

			initCell();
			initPallet();
			initChart();
			drawPallet();
			
		}
		
		private function initChart():void{
			for(var r:int=0;r<=5;++r){
				for(var g:int=0;g<=5;++g){
					for(var b:int=0;b<=5;++b){
						var tmp:Sprite=new Sprite();
						var col:uint=(r*51)*256*256 + (g*51)*256 + b*51;
						tmp.graphics.beginFill(col);
						tmp.graphics.lineStyle(1, 0xcccccc);
						tmp.graphics.drawRect(300+r*8 + (b%3)*48 ,100 + g*8 + Math.floor(b/3)*48 ,8,8);
						tmp.graphics.endFill();
						tmp.addEventListener(flash.events.MouseEvent.MOUSE_DOWN,changeColorArr(col));
						addChild(tmp);
					}
				}
			}
		}
		
		private function initPallet():void{
			color[0]=0x000000;
			color[1]=0xff0000;
			color[2]=0x00ff00;
			color[3]=0x0000ff;
			color[4]=0xffff00;
			color[5]=0x00ffff;
			color[6]=0xff00ff;
			color[7]=0xffffff;

			color[8]=0x000000;
			color[9]=0xbb0000;
			color[10]=0x00bb00;
			color[11]=0x0000bb;
			color[12]=0xbbbb00;
			color[13]=0x00bbbb;
			color[14]=0xbb00bb;
			color[15]=0xbbbbbb;

			color[16]=0x000000;
			color[17]=0x770000;
			color[18]=0x007700;
			color[19]=0x000077;
			color[20]=0x777700;
			color[21]=0x007777;
			color[22]=0x770077;
			color[23]=0x777777;

			color[24]=0x000000;
			color[25]=0x330000;
			color[26]=0x003300;
			color[27]=0x000033;
			color[28]=0x333300;
			color[29]=0x003333;
			color[30]=0x330033;
			color[31]=0x333333;

			for(var i:int=0;i<color.length;++i){
				var pallet:Sprite = new Sprite();
				pallet.graphics.beginFill(color[i]);
				
				if(i==scidx){
					pallet.graphics.lineStyle(1, 0x333333);
				} else {
					pallet.graphics.lineStyle(1, 0xcccccc);
				}
				pallet.graphics.drawRect(300+(i%8)*20,1+Math.floor(i/8)*20,16,16);
				pallet.graphics.endFill();
				pallet.addEventListener(flash.events.MouseEvent.MOUSE_DOWN,changeColorIdx(i));
				pallet.addEventListener(flash.events.MouseEvent.MOUSE_OVER,ov_pallet(i));
				pallet.addEventListener(flash.events.MouseEvent.MOUSE_OUT,ou_pallet(i));

				addChild(pallet);
				palle[i]=pallet;
			}

		}
		

		private function initCell():void{

			for(var _h:int=0;_h<__h;++_h){
				for(var _w:int=0;_w<__w;++_w){
					var idx:int=_h*__h+_w;
					var cell:Sprite = new Sprite();
					cell.graphics.beginFill(0xffffff);
					cell.graphics.lineStyle(1, 0xdddddd);
					cell.graphics.drawRect(__s*_w, __s*_h, __s, __s);
					cell.graphics.endFill();
					cell.addEventListener(flash.events.MouseEvent.MOUSE_MOVE,func(idx));
					cell.addEventListener(flash.events.MouseEvent.MOUSE_DOWN,dn_mouse);
					cell.addEventListener(flash.events.MouseEvent.MOUSE_UP,up_mouse);
					addChild(cell);
					
					cells[idx]=cell;
					coidx[idx]=7;
				}
			}
		}
		
		private function redrawCell():void{
			for(var _h:int=0;_h<__h;++_h){
				for(var _w:int=0;_w<__w;++_w){
					var idx:int=_h*__h+_w;
					if(coidx[idx]==scidx){
						var cell:Sprite = cells[idx];
						cell.graphics.beginFill(color[coidx[idx]]);
						cell.graphics.lineStyle(1, 0xdddddd);
						cell.graphics.drawRect(__s*_w, __s*_h, __s, __s);
						cell.graphics.endFill();
					}
				}
			}
		}

		private function func(idx:int):Function{
			return function(event:Event):void{
				if(_flag==1){
					
					var _h:int=Math.floor(idx/__h);
					var _w:int=idx%__h;

					tf.text=idx + " : " + _h + "/"+_w;
					
					cells[idx].graphics.beginFill(color[scidx]);
					cells[idx].graphics.lineStyle(1, 0xdddddd);
					cells[idx].graphics.drawRect(__s*_w, __s*_h, __s, __s);
					cells[idx].graphics.endFill();
					coidx[idx]=scidx;
				}
			}
		}
		
		private function dn_mouse(event:MouseEvent):void{
			_flag=1;
		}
		
		private function up_mouse(event:MouseEvent):void{
			_flag=0;
		}
		
		// change pallet color
		private function changeColorArr(col:uint):Function{
			return function(event:Event):void{
				color[scidx]=col;
				drawPallet();
				redrawCell();
				
			}
		}
		
		// for pallet
		private function changeColorIdx(idx:int):Function{
			return function(event:Event):void{
				scidx=idx;
				tf.text=""+idx;
				drawPallet();
			}
		}

		private function ov_pallet(idx:int):Function{
			return function(event:Event):void{
				var tmp:Sprite = palle[idx];
				tmp.graphics.beginFill(color[idx]);
				tmp.graphics.lineStyle(1, 0x333333);
				tmp.graphics.drawRect(300+(idx%8)*20,1+Math.floor(idx/8)*20,16,16);
				tmp.graphics.endFill();
			}
		}
		
		private function ou_pallet(idx:int):Function{
			return function(event:Event):void{
				if(idx!=scidx){
				var tmp:Sprite = palle[idx];
				tmp.graphics.beginFill(color[idx]);
				tmp.graphics.lineStyle(1, 0xcccccc);
				tmp.graphics.drawRect(300+(idx%8)*20,1+Math.floor(idx/8)*20,16,16);
				tmp.graphics.endFill();
				}
			}
		}
		
		private function drawPallet():void{

			for(var i:int=0;i<color.length;++i){
				var pallet:Sprite=palle[i];

				pallet.graphics.beginFill(color[i]);
				
				pallet.graphics.lineStyle(1, 0xcccccc);
				if(i==scidx){
					pallet.graphics.lineStyle(1, 0x333333);
				}
				pallet.graphics.drawRect(300+(i%8)*20,1+Math.floor(i/8)*20,16,16);
				pallet.graphics.endFill();
			}
		}
	}
}