/**
 * Copyright agenda23 ( http://wonderfl.net/user/agenda23 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/ciQx
 */

package
{
    import flash.display.*;
    import flash.events.*;
    import org.papervision3d.cameras.Camera3D;
    import org.papervision3d.render.BasicRenderEngine;
    import org.papervision3d.scenes.Scene3D;
    import org.papervision3d.view.Viewport3D;
    import org.papervision3d.objects.primitives.*;
    import org.papervision3d.materials.*;
    import org.papervision3d.materials.special.CompositeMaterial;

    [SWF(backgroundColor=0x000000)]

    public class Main extends Sprite
    {
        private var scene:Scene3D;
        private var viewport:Viewport3D;
        private var camera:Camera3D;
        private var renderer:BasicRenderEngine;
        private var objSphere:Sphere;

        public function Main()
        {
            stage.align = StageAlign.TOP_LEFT;
            stage.scaleMode = StageScaleMode.EXACT_FIT;
            stage.quality = StageQuality.LOW;
            init3D();
        }

        private function init3D():void
        {
            //ビューポート設定
            viewport = new Viewport3D(0,0,true);
            viewport.opaqueBackground = 0x000000;
            addChild(viewport);

            //レンダー設定
            renderer = new BasicRenderEngine();

            //カメラ設定
            camera = new Camera3D();
            camera.z = -300;
            camera.focus = 500;
            camera.zoom = 1;

            //シーン設定
            scene = new Scene3D();

            //マテリアル設定
            var colorMat:ColorMaterial = new ColorMaterial( 0x006699, 1 );
            var wireMat:WireframeMaterial = new WireframeMaterial( 0x3EFA00 );
            var compoMat:CompositeMaterial = new CompositeMaterial();
            compoMat.addMaterial(colorMat);
            compoMat.addMaterial(wireMat);
            compoMat.doubleSided = true;

            //Plane生成
            objSphere = new Sphere(wireMat, 100, 30, 10 );
            //objSphere = new Plane(compoMat, 300, 300);
            scene.addChild(objSphere);

            addEventListener(Event.ENTER_FRAME, onEnterFrame);
        }

        private function onEnterFrame(event:Event):void
        {
         //   objSphere.rotationY += 2;
              objSphere.rotationY = stage.mouseX;
              objSphere.rotationX = stage.mouseY;
            renderer.renderScene(scene,camera,viewport);
        }
    }
}