/**
 * Copyright geko ( http://wonderfl.net/user/geko )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/chfP
 */

package {
    import flash.display.Sprite;
    import flash.events.MouseEvent;
    import flash.text.TextField;
    import caurina.transitions.Tweener;
    
    [SWF(frameRate=120)]
    public class FlashTest extends Sprite {
        private var txt:TextField;
        private var _width:Number = 150;
        private var _height:Number = 150;
        public override function set width(val:Number):void{ _width = Math.max(val,150); draw(); }
        public override function get width():Number{ return _width; }
        public override function set height(val:Number):void{ _height = Math.max(val, 100); draw(); }
        public override function get height():Number{ return _height; }
        
        public function FlashTest() {            
            txt = addChild(new TextField) as TextField;
            _width = stage.stageWidth-20;
            draw();
            
            txt.textColor = 0xFFFFFF;
            txt.text = "タブ";
            txt.x = 20; txt.y = 12;
            txt.width = 100;
            txt.height = 30;
            txt.selectable = false;
            txt.addEventListener(MouseEvent.CLICK, click);

            
        }
        
        private function click(event:MouseEvent):void{
            txt.removeEventListener(MouseEvent.CLICK, click);
            Tweener.addTween(this, {height:height > 150 ? 150 : stage.stageHeight-30, time:0.6, 
                                    onComplete:function onComplete():void{
                                        txt.addEventListener(MouseEvent.CLICK, click);
                                        txt.text = "タブ";
                                    }});
        }

        
        public function draw():void{
            txt.text = String("height = " +int(_height));
            graphics.clear();
            graphics.beginFill(0x888888, 0.8);
            //矩形の描画
            graphics.drawRect(10, 30, _width, _height);
            //タブの描画
            graphics.moveTo(10, 30);
            graphics.lineTo(15, 30);
            graphics.lineTo(17.5, 10);
            graphics.lineTo(107.5, 10);
            graphics.lineTo(110, 30);
            graphics.endFill();
        }

    }
}