/**
 * Copyright codeonwort ( http://wonderfl.net/user/codeonwort )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/cgZR
 */

// forked from codeonwort's perturbation effect study
// forked from codeonwort's perlin noise scroll test
package {
    
    import flash.filters.DisplacementMapFilter
    import flash.geom.Rectangle
    import flash.geom.Point
    import flash.events.Event
    import flash.display.Sprite
    import flash.display.Bitmap
    import flash.display.BitmapData
    
    public class FlashTest extends Sprite {
        
        private var map:BitmapData // original map data
        private var dmfmap:BitmapData // actually this is used for displacement mapping
        private var dmf:DisplacementMapFilter
        
        // displayed on screen
        private var canvas:BitmapData
        private var canvas2:BitmapData
        
        private var cloud:BitmapData
        private var cloud2:BitmapData
        
        private var uScroll:int = 0, uRect:Rectangle
        private var vScroll:int = 465, vRect:Rectangle
        
        private var uScroll2:int = 0, vScroll2:int = 465
        
        public function FlashTest() {
            // write as3 code here..
            var temp:BitmapData = new BitmapData(465, 465, false, 0x0)
            temp.perlinNoise(465, 465, 8, Math.random() * int.MAX_VALUE, true, true, 1)
            
            var temp2:BitmapData = new BitmapData(465, 465, false, 0x0)
            temp2.perlinNoise(465, 465, 8, Math.random() * int.MAX_VALUE, true, true, 2)
            temp.copyChannel(temp2, temp.rect, new Point, 2, 2)
            
            map = new BitmapData(465*2, 465, false, 0x0)
            map.copyPixels(temp, temp.rect, new Point)
            map.copyPixels(temp, temp.rect, new Point(465, 0))
            temp.dispose()
            temp2.dispose()
            
            cloud = new BitmapData(465, 465, true, 0x0)
            cloud.perlinNoise(465/2, 465/2, 8, Math.random() * int.MAX_VALUE, true, true, 4)
            
            cloud2 = new BitmapData(465, 465, true, 0x0)
            cloud2.perlinNoise(465/2, 465/2, 8, Math.random() * int.MAX_VALUE, true, true, 4, true)
            
            dmfmap = new BitmapData(465, 465, false, 0x0)
            dmf = new DisplacementMapFilter(dmfmap, new Point, 1, 2, 100, 100)
            uRect = new Rectangle(0, 0, 465, 465)
            vRect = new Rectangle(0, 0, 465, 465)
            
            canvas = new BitmapData(465, 465, true, 0x0)
            canvas2 = new BitmapData(465, 465, true, 0x0)
            
            var bmp1:Bitmap = addChild(new Bitmap(canvas)) as Bitmap
            var bmp2:Bitmap = addChild(new Bitmap(canvas2)) as Bitmap
            bmp2.blendMode = "add"
            bmp1.rotationX = bmp2.rotationX = -45
            
            addEventListener("enterFrame", loop)
        }
        
        private function loop(e:Event):void {
            uScroll += 6
            vScroll -= 6
            if(uScroll > 465) uScroll = 0
            if(vScroll < 0) vScroll = 465
            uRect.x = uScroll
            vRect.x = vScroll
            
            dmfmap.copyChannel(map, uRect, new Point, 1, 1)
            dmfmap.copyChannel(map, vRect, new Point, 2, 2)
            
            canvas.applyFilter(cloud, canvas.rect, new Point, dmf)
            
            uScroll2 += 3
            vScroll2 -= 3
            if(uScroll2 > 465) uScroll2 = 0
            if(vScroll2 < 0) vScroll2 = 465
            uRect.x = uScroll2
            vRect.x = vScroll2
            dmfmap.copyChannel(map, uRect, new Point, 1, 1)
            dmfmap.copyChannel(map, vRect, new Point, 2, 2)
            
            canvas2.applyFilter(cloud2, canvas.rect, new Point, dmf)
        }
        
    }
    
}