/**
 * Copyright minon ( http://wonderfl.net/user/minon )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/cgLl
 */

/**
 * 激しい吹き出し
 * イマイチ、非常に残念な感じ
 * 
 * クリックでアニメーションストップ
 */
package  {
	import flash.display.Graphics;
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.events.MouseEvent;
	import flash.geom.Point;
	import flash.text.TextField;
	import flash.text.TextFieldAutoSize;
	import flash.text.TextFormat;
	import flash.text.TextFormatAlign;
	
	[SWF(width="465",height="465",frameRate="20",backgroundColor="0xFFFFFF")]
	
	/**
	 * ...
	 * @author minon
	 */
	public class Balloon extends Sprite {
		
		private var _container:Sprite;
		private var _isPlaying:Boolean = true;
		
		public function Balloon() {
			
			_container = new Sprite();
			this.addChild( _container );
			
			var txt:TextField = new TextField();
			txt.autoSize = TextFieldAutoSize.LEFT;
			var tf:TextFormat = new TextFormat();
			tf.align = TextFormatAlign.CENTER;
			tf.size = 24;
			txt.defaultTextFormat = tf;
			txt.text = "早く帰りたい！";
			txt.x = ( stage.width - txt.width ) / 2 + 237.5;
			txt.y = ( stage.height - txt.height ) / 2 + 237.5;
			this.addChild( txt );
			
			stage.addEventListener(MouseEvent.CLICK, _change );
			stage.addEventListener(Event.ENTER_FRAME, _render );
			
		}
		
		private function _change(e:Event):void {
			
			if ( _isPlaying ) {
				stage.removeEventListener(Event.ENTER_FRAME, _render );
				_isPlaying = false;
			}
			else {
				stage.addEventListener(Event.ENTER_FRAME, _render );
				_isPlaying = true;
			}
		}
		
		private function _render(e:Event):void {
			
			var g:Graphics = _container.graphics;
			g.clear();
			_drawBalloon( g );
		}
		
		private function _drawBalloon( g:Graphics ):void {
			
			var outAry:Array = [];
			var inAry:Array = [];
			
			var a:int = 20;
			var len:int = 160;
			var lv:int;
			
			var d:int = 360 + Math.random() * 5;
			while ( d > a/2 ) {
				
				var n:Number = Math.sin( d / 10 ) * 4;
				
				lv = len + Math.random() * 60 + n * 3;
				var x:Number = Math.sin( d * Math.PI / 180 ) * lv + 230;
				var y:Number = Math.cos( d * Math.PI / 180 ) * lv + 230;
				
				lv = 60;
				var x2:Number = Math.sin( ( d + ad/2 ) * Math.PI / 180 ) * lv + 230;
				var y2:Number = Math.cos( ( d + ad/2 ) * Math.PI / 180 ) * lv + 230;
				
				outAry.push( new Point( x, y ) );
				inAry.push( new Point( x2, y2 ) );
				
				var ad:int = Math.random() * n + a / 2;
				
				d -= ad
				
			}
			
			g.lineStyle( 4, 0 );
			g.moveTo( outAry[0].x, outAry[0].y );
			for ( var i:int = 1 ; i < outAry.length ; i++ ) {
				g.curveTo( inAry[i].x, inAry[i].y, outAry[i].x, outAry[i].y );
				
			}
			g.curveTo( inAry[0].x, inAry[0].y, outAry[0].x, outAry[0].y );
			
		}
		
	}
	
}