/**
 * Copyright ricserje ( http://wonderfl.net/user/ricserje )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/cgJ4
 */

package {
    import flash.trace.Trace;
    import flash.ui.Mouse;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.filters.GlowFilter;
    
    import away3d.containers.View3D;
    import away3d.primitives.*;
    import away3d.events.MouseEvent3D;
    //import away3d.materials.utils.SimpleShadow;
    import away3d.cameras.*
    import away3d.materials.*
    
    //ui
    import com.bit101.components.*;
    import com.bit101.components.Slider;
    
    //
    import flash.text.TextField;
    
    //tween
    import caurina.transitions.Tweener;
 
    public class FlashTest extends Sprite {
  
        private var plane:Plane;   
        private var view:View3D;
        private var cam:Camera3D
        private var sphere:Sphere;
        private var et:TextField;
        private var glow:GlowFilter;
        public function FlashTest() {
            // write as3 code here..
                trace('test')
                graphics.beginFill(0xddd)
                graphics.drawRect(12,12,150,150) 
                et = new TextField();
                et.x = 0;
                et.y = 350;
                et.text = "...";
                addChild(et);
            //cam
            cam = new Camera3D({zoom:2,focus:100,x:0,z:-550,y:24});
            //cam = new HoverCamera3D({zoom:2, focus:100, distance:250});
            //view
            view = new View3D({x:250,y:200,camera:cam});
            addChild(view);
            //objects
            plane = new Plane();
            plane.bothsides = true;
            plane.scaleX = plane.scaleY = 3.5;
            plane.y =-120;
             
            sphere = new Sphere();
            sphere.ownCanvas = true; //for glowfilter
            sphere.addOnMouseDown(clickOn);
            sphere.addOnMouseUp(clickOff);
            sphere.addOnMouseOver(hoverOn);
            sphere.addOnMouseOut(hoverOff);
         
           
            
            view.scene.addChild(sphere);
            view.scene.addChild(plane);
            view.render();
            //ui
            mincomps();
            //listener
            addEventListener(Event.ENTER_FRAME, onEnterFrame);   
        }
        
        public function mincomps():void{
            
            var slider:Slider = new Slider(Slider.HORIZONTAL, this, 40, 405, function ():void{
                  cam.x = slider.value*10;
                  et.text = "Xcam "+slider.value;
                  //cam.tilt(slider.value*0.01);
                  //plane.y += 0.1;
                 // view.scene.rotationX = slider.value*0.1;
                  //view.render();
                 //view.clear(); 
                });
            var slider2:Slider = new Slider(Slider.HORIZONTAL,this,40,420,function ():void{
                 cam.z = -slider2.value*10;
                 et.text = "Zcam "+slider2.value;
                })
         
        }
        private function clickOn(e:MouseEvent3D):void{
                //sphere.scaleX += 0.1;
                et.text = "sphereDOWN";
                //tween
                Tweener.addTween(sphere, {
                    y: 12,
                    scaleX: 0.5,
                    scaleY: 0.1,
                    //alpha:0,
                    time: 2,
                    transition: "easeInOutBounce",
                    onComplete: function ():void{
                                //completed
                              Tweener.addTween(sphere, {
                                y: 0,
                                scaleX: 1,
                                scaleY: 1,
                                //alpha:0,
                                time: 2,
                                transition: "easeInOutSine",
                                onComplete: function ():void{
                                    
                                            //finished return state
                                    },
                                onCompleteParams: [sphere]
                            });               
                            
                        },
                    onCompleteParams: [sphere]
                });
            
            }
        
        private function clickOff(e:MouseEvent3D):void{
                //sphere.scaleX -= 0.1;
                et.text = "sphereUP";
            }
                
        private function hoverOn(e:MouseEvent3D):void{
                et.text = "inSphere";
                glow = new GlowFilter();
                glow.color = 0x3399CC;
                glow.alpha = 0.39;
                glow.blurX = 69;
                glow.blurY = 116;
                glow.strength = 1;
                sphere.filters = [glow,glow];
                
            }        
            
        private function hoverOff(e:MouseEvent3D):void{
                et.text = "outSphere";
                glow.strength = 0;
            }     
            
         private function onEnterFrame(e:Event):void {
              plane.rotationX += 0.1;
             view.scene.rotationX = -(stage.mouseY - (stage.stageHeight >> 1));
             view.scene.rotationY = stage.mouseX - (stage.stageWidth >> 1);
              view.render();
        }
        
         
    }
}