/**
 * Copyright Scmiz ( http://wonderfl.net/user/Scmiz )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/cfsk
 */

package {
	import flash.display.Graphics;
    import flash.display.Sprite;
	import flash.events.Event;
	import flash.system.System;
    public class FlashTest extends Sprite {
		private var _array:Array;
		
        public function FlashTest() {
			_array = new Array();
			this.addEventListener(Event.ENTER_FRAME, proc);

			var g:Graphics = this.graphics;
			g.beginFill(0x000000);
			g.drawRect(0, 0, 465, 465);
			g.endFill();
        }
		
		private function proc(e:Event):void {
			add(2);
			
			for each(var snow:Snow in _array) {
				snow.update();
			}
			
			for (var index:int = 0; index < _array.length; ++index) {
				if (_array[index].y > 500) {
					this.removeChild(_array[index]);
					_array.splice(index, 1);
					--index;
					continue;
				}
			}
			
			System.gc();
		}
		
		private function add(num:uint):void {
			for (var index:uint = 0; index < num; ++index) {
				var s:Snow = new Snow();
				s.x = Math.random() * 465;
				s.y = -20;
				this.addChild(s);
				_array.push(s);
			}
		}
    }
}

import flash.display.Graphics;
import flash.display.Sprite;

class Snow extends Sprite {
	private var _drawPosX:Number;
	private var _drawPosY:Number;
	private var _size:Number;
	private var _length:Number;
	private var _speedX:Number;
	private var _speedY:Number;
	private var _rotSpeed:Number;
	
	private const SPLIT_NUM:uint = 2;
	
	public function Snow() {
		_size = Math.random() * 5 + 5;
		_length = (1.72 * _size) / Math.pow(3, SPLIT_NUM);
		_speedX = Math.random() * 1 - 0.5;
		_speedY = Math.random() * 4 + 2;
		_rotSpeed = (Math.random() * 2 + 2) * (Math.random() < 0.5 ? 1 : -1);
		
		draw();
	}
	
	public function update():void {
		this.x += _speedX;
		this.y += _speedY;
		this.rotationZ += _rotSpeed;
	}
	
	private function draw():void {
		var g:Graphics = this.graphics;
		g.lineStyle(1, 0xffffff);
		
		for (var index:uint = 0; index < 3; ++index) {
			var rad:Number = (Math.PI * 2 / 3 * index) + (-Math.PI * 0.5);
			_drawPosX = Math.cos(rad) * _size;
			_drawPosY = Math.sin(rad) * _size;
			drawIn(SPLIT_NUM, rad - (Math.PI * 2 * 5 / 12));
		}
	}

	private function drawIn(num:uint, rad:Number):void {
		var g:Graphics = this.graphics;
		
		if (num == 0) {
			var px:Number = _length * Math.cos(rad) + _drawPosX;
			var py:Number = _length * Math.sin(rad) + _drawPosY;
			g.moveTo(_drawPosX, _drawPosY);
			g.lineTo(px, py);
			
			_drawPosX = px;
			_drawPosY = py;
			return;
		}
		
		drawIn(num - 1, rad);
		drawIn(num - 1, rad + (Math.PI / 3));
		drawIn(num - 1, rad - (Math.PI / 3));
		drawIn(num - 1, rad);
	}
}
