/**
 * Copyright hashito ( http://wonderfl.net/user/hashito )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/cfcM
 */

// MainStage
package {
	import flash.display.Sprite;
	[SWF(frameRate=60,width=456,height=456)]
	public class MainStage extends Sprite {
		public function MainStage(){
			addChild(new Main());
		}
	}
}

import flash.display.*;
import flash.filters.BlurFilter;
import flash.geom.Point;
import flash.geom.ColorTransform;
import flash.events.*;
import flash.text.TextField;
import net.hires.debug.Stats;

class debug{
	public static var out:TextField=new TextField();
}

class Main extends Sprite{
	public const H:Number = 456;
	public const W:Number = 456;
	
	
	private var m:Map = new Map(W,H);
	//Constructor
	public function Main() {addEventListener(Event.ADDED_TO_STAGE, init);}
	//init
	public function init(e:*):void{
		
		m.addSeed(new Seed(0xff0000,m,W/2,H/2));
		
		reset();
		addChild(m);
		debug.out.autoSize=flash.text.TextFieldAutoSize.LEFT;
		addChild(debug.out);
		debug.out.text="0";
		m.addEventListener(Event.ENTER_FRAME ,reset);
	}
	public function reset(e:Event=null):void{
		m.update();
	}
}
class Map extends Bitmap{
	private var seeds:Vector.<Seed>=new Vector.<Seed>();
	public var w:int,h:int;
	public function  addSeed(s:Seed):void{seeds.push(s);}
	public function  removeSeed(s:Seed):void{seeds.splice(seeds.indexOf(s),1);}
	public function  stepOn(x:int,y:int,c:uint):void{
		if(isPoint(x,y))
			this.bitmapData.setPixel(x,y,c);
	}
	public function Map(w:int,h:int){
		this.w=w;this.h=h;
		this.bitmapData = new BitmapData(w,h,false,0xffffff);
	}
	public function isPoint(x:int,y:int):Boolean{
		return x<=w && y<=h && 0<=x && 0<=y ;
	}
	public function update():void{
		for each(var s:Seed in seeds)s.update();
	}
}
class Seed {
	public var color:uint,x:int,y:int,life:int=1;
	private var map:Map;
	private var points:Vector.<Point> = new Vector.<Point>(GROWING,true);
	private const GROWING:int=500,BREEDING:int =10,LIFE:int = BREEDING+GROWING;
	public function Seed(color:uint,map:Map,x:int,y:int){
		this.color=color;
		this.map=map;
		this.x=x;
		this.y=y;
		for(var i:int=0;i<points.length;i++){
			points[i]=new Point(x,y);
		}
	}
	public function update():void{
		if(life < GROWING){
			function ran():int{return Math.floor(Math.random()*3)-1;}
			points[life].x = points[life-1].x + ran();
			points[life].y = points[life-1].y + ran();
		}else if(life < LIFE){
			breeding();
			color+=(0xffffff-color)/BREEDING;
		}else{
			map.removeSeed(this);
		}
		life++;

		draw(color);
	}
	private function breeding():void{
		if((Math.random()*10) > 8){
			var px:int = Math.floor(Math.random()*GROWING);
			var py:int = Math.floor(Math.random()*GROWING);
			var x:int  = points[px].x+Math.floor(Math.random()*10)-5;
			var y:int  = points[py].y+Math.floor(Math.random()*10)-5;
			map.addSeed(new Seed(0xffffff*Math.random(),map,x,y));
		}
	}
	private function draw(c:uint):void{
		function callback(p:Point, i:int, v:Vector.<Point>):void{ map.stepOn(p.x,p.y,c); }
		points.forEach(callback);
	}
}
