/**
 * Copyright hankuro ( http://wonderfl.net/user/hankuro )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/cfP5
 */

package 
{
	import caurina.transitions.Tweener;
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.filters.BlurFilter;
	import flash.geom.ColorTransform;
	import flash.geom.Point;
	import org.papervision3d.core.effects.BitmapLayerEffect;
	import org.papervision3d.core.effects.view.ReflectionView;
	import org.papervision3d.core.geom.renderables.Triangle3D;
	import org.papervision3d.core.geom.renderables.Vertex3D;
	import org.papervision3d.core.geom.TriangleMesh3D;
	import org.papervision3d.core.math.NumberUV;
	import org.papervision3d.lights.PointLight3D;
	import org.papervision3d.materials.ColorMaterial;
	import org.papervision3d.materials.shadematerials.GouraudMaterial;
	import org.papervision3d.materials.special.ParticleMaterial;
	import org.papervision3d.materials.utils.MaterialsList;
	import org.papervision3d.materials.WireframeMaterial;
	import org.papervision3d.objects.DisplayObject3D;
	import org.papervision3d.objects.primitives.Cube;
	import org.papervision3d.objects.primitives.Cylinder;
	import org.papervision3d.objects.primitives.Plane;
	import org.papervision3d.objects.primitives.Sphere;
	import org.papervision3d.objects.special.ParticleField;
	import org.papervision3d.view.BasicView;
	import org.papervision3d.view.layer.BitmapEffectLayer;
	
	[SWF(width = "500", height = "500", backgroundColor = "0" )] 
	
	/**
	 * http://wonderfl.net/code/1034a79d9022a8f5bbbdf763dd68a871d81f3c9e
	 * 「宇宙」を参考に、Sphereとcubeの面の位置にTriangleMesh3Dを貼り付けてみました。
	 * なお、光り輝くロジックは、「宇宙」のロジックをそのまま使用しました。また、面の位置の取り出しは
	 * http://zapruder.main.jp/blog/?cat=3
	 * を参考にしました。
	 * 
	 * 「課題」
	 * 簡単にTriangleMesh3Dを自由な位置に設置できるロジックを考えたい。
	 */
	public class Main extends BasicView
	{
		public var sphere:Sphere;
		public var cube:Cube;
		public var cylinder:Cylinder;
		public var plane:Plane;
		private var coltrans:ColorTransform;
		private var angle:Number = 0;
		private var bfm:BitmapEffectLayer;
		private var bfm_p:BitmapEffectLayer;
		private var obj3D:DisplayObject3D;
		private var num:Number = 0;
		private var cheng_sw:Boolean = false;
		private var meshface:Triangle3D;
		private var mesh_array:Array;
		private var uvA:NumberUV;
		private var uvC:NumberUV;
		private var uvB:NumberUV;
		private var v0:Vertex3D;
		private var v1:Vertex3D;
		private var v2:Vertex3D;
		private var max_num:Number;
		private var triangle_init:Array = [new Vertex3D( -10, 10, 0 ),new Vertex3D( 10, 10, 0 ),new Vertex3D( 0, 0, 0 )];
		
		public function Main() 
		{
			//
			// スーパークラスのコンストラクターを呼び出す。
			//
			super(500, 500, false, false);
			//
			// カメラ位置の設定
			//
			camera.z = -400;
			//　カラーの変更　引数は
			//　ColorTransform（赤の乗数値，緑の乗数値，青の乗数値，アルファの乗数値，
			//　赤のオフセット，緑のオフセット，青のオフセット，アルファのオフセット）
			coltrans = new ColorTransform(0, 0, 0, 1, 0, 0, 0, 0);
			//
			// 回転用の空のオブジェクト
			//
			obj3D = new DisplayObject3D();
			scene.addChild(obj3D);
			//
			// モデルとなる形（今回は、sphereとcubeのみ）の宣言とモデルの最大面数取得
			//
			var wire:WireframeMaterial = new WireframeMaterial(0xFFFFFF,0);
			sphere = new Sphere(wire, 100, 20, 20);
			cube = new Cube(new MaterialsList( { all:new ColorMaterial(0xFF0000, 100) } ), 200, 200, 200, 7, 7, 5);
			cylinder = new Cylinder(new ColorMaterial(0xFF0000, 0), 200, 200, 16, 15,-1);
			plane = new Plane(new ColorMaterial(0xFF0000, 0), 200, 200, 15, 15);
			max_num = Math.max(sphere.geometry.faces.length, cube.geometry.faces.length, cylinder.geometry.faces.length, plane.geometry.faces.length);
			trace (max_num);
			// 
			// マテリアルの宣言。なお、スモークのようなマテリアルはBitmapEffectLayerです。また、BitmapEffectLayerはParticleFieldとriangleMesh3D分けています。
			//
			var mtr:ParticleMaterial =  new ParticleMaterial(0xFFFFFF, 10, 1);
			var particles:ParticleField = new ParticleField(mtr, 100, 5, 2000, 2000, 2000);
			obj3D.addChild(particles);
			bfm_p = new BitmapEffectLayer(viewport, stage.stageWidth, stage.stageHeight, true, 0, "clear_pre", false, false );
			bfm_p.addEffect(new BitmapLayerEffect(new BlurFilter(10, 10, 3), false));
			viewport.containerSprite.addLayer(bfm_p);
			bfm_p.addDisplayObject3D(particles);			
			bfm = new BitmapEffectLayer(viewport, stage.stageWidth, stage.stageHeight, true, 0, "clear_pre", false, false );
			bfm.addEffect(new BitmapLayerEffect(new BlurFilter(10, 10, 3), false));
			var mat:ColorMaterial =  new ColorMaterial(0xFFFFFF);
			viewport.containerSprite.addLayer(bfm);
			//
			// TriangleMesh3Dの初期化
			//
			mesh_array = new Array(max_num);
			for (var i:Number = 0; i < max_num ; i++) {
				mesh_array[i] = new TriangleMesh3D(mat, new Array(), new Array(), null );
				v0 = new Vertex3D( -10, 10, 0 );
				v1 = new Vertex3D( 10, 10, 0 );
				v2 = new Vertex3D( 0, 0, 0 );
				mesh_array[i].geometry.vertices.push( v0 );
				mesh_array[i].geometry.vertices.push( v1 );
				mesh_array[i].geometry.vertices.push( v2 );
				uvA = new NumberUV( 0, 0 );
				uvC = new NumberUV( 1, 0 );
				uvB = new NumberUV( 0, 1 );
				mesh_array[i].geometry.faces.push( new Triangle3D( mesh_array[i], new Array(v0,v1,v2), null, new Array(uvA,uvC,uvB) ));
				mesh_array[i].geometry.ready = true;
				obj3D.addChild(mesh_array[i]);
				bfm.addDisplayObject3D(mesh_array[i]);	
			}
			addEventListener(Event.ENTER_FRAME, onRun , false, 0, true);
			startRendering();
			sphere_make();
		}
		//
		//　sphereの形にTriangleMesh3Dを移動させる。
		//
		private function sphere_make():void {
			for (var i:Number = 0; i <  sphere.geometry.faces.length; i++) {
				meshface = sphere.geometry.faces[i];
				for (var n:Number = 0; n < 3; n++) {
					Tweener.addTween(mesh_array[i].geometry.vertices[n], { x: meshface.vertices[n].x,
																		   y: meshface.vertices[n].y,
																		   z: meshface.vertices[n].z,
																		   delay:i*.1,
																		   time:2,
																		   transition:"easeInOutCirc" } );
				}
			}
			Tweener.addTween(this,{delay:i*.1,onComplete:cube_make});
		}
		//
		//　cubeの形にTriangleMesh3Dを移動させる。
		//
		private function cube_make():void {
			for (var i:Number = 0; i <  cube.geometry.faces.length; i++) {
				meshface = cube.geometry.faces[i];
				for (var n:Number = 0; n < 3; n++) {
					Tweener.addTween(mesh_array[i].geometry.vertices[n], { x: meshface.vertices[n].x,
																		   y: meshface.vertices[n].y,
																		   z: meshface.vertices[n].z,
																		   delay:i*.1,
																		   time:2,
																		   transition:"easeInOutCirc" } );
				}
			}
			Tweener.addTween(this,{delay:i*.1,onComplete:sphere_make});
			if (i < mesh_array.length) triangle_back(i);			
		}
		//
		//　cubeの描写で余ったTriangleMesh3Dを初期位置に戻す。
		//
		private function triangle_back(p:Number):void {
			for (var i:Number = p; i < mesh_array.length ; i++) {
				for (var n:Number = 0; n < 3; n++) {
					Tweener.addTween(mesh_array[i].geometry.vertices[n], { x: triangle_init[n].x,
																		   y: triangle_init[n].y,
																		   z: triangle_init[n].z,
																		   delay:cube.geometry.faces.length*.1} );
				}
			}
		}
		//
		// フレームイベント
		//
		private function onRun(evt:Event):void {
			//
			// obj3DにaddChildされたオブジェクトの回転
			//
			obj3D.rotationY += .7;
			obj3D.rotationX += .7;
			
			//
			// カラーの変更
			//  カラー変更の計算はイマイチ勉強不足で、説明ができません。（現在勉強中）
			//
			angle+=.01;
			var sin:Number = Math.sin(angle)
			var cos:Number = Math.cos(angle)
			if (sin < .1) sin = Math.abs(sin)+.1;
			if (cos < .1) cos = Math.abs(cos)+.1;
			
			coltrans.redMultiplier = sin/4;
			coltrans.greenMultiplier = cos/2;
			coltrans.blueMultiplier = sin;
			
			bfm.drawCommand.colorTransform = coltrans;
			
		}
		
	}
	
}