/**
 * Copyright a24 ( http://wonderfl.net/user/a24 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/celW
 */

// forked from clockmaker's [PV3D]外部画像をLoaderを利用して読み込んだ場合の実装方法
package {
    import flash.display.*;
    import flash.events.*;
    import flash.net.*;
    import flash.system.*;
    import org.papervision3d.materials.*;
    import org.papervision3d.objects.primitives.*;
    import org.papervision3d.view.*;
    
    /**
    * 外部画像をBitmapFileMaterialでなく、
    * Loaderを経由してMovieMaterialで表示させるサンプル
    * 背景透過しないクポ～
    */
    
    public class Main extends BasicView {
        public function Main():void {

            var sp:Shape = new Shape();
            sp.graphics.beginFill( 0x000000 );
            sp.graphics.drawRect( 0 , 0 , 465 , 465 );
            addChildAt(sp,0);
            
            // LoaderContextを準備(クロスドメイン対策：自分のドメインだったらいりません)
            var context:LoaderContext = new LoaderContext(true);

            // 外部ファイルを読み込みます
            var loader:Loader = new Loader();
            loader.load(new URLRequest("http://assets.wonderfl.net/images/related_images/b/b5/b5ff/b5ff2972aad3216667a5cc3c9e68730d97b6088e"), context);
            
            // マテリアル(テクスチャ)をMovieMaterialをして作成
            // 3番目の引数(animated)をtrueに設定することで常に最新の絵が反映される
            var material:MovieMaterial = new MovieMaterial(loader, true, true);
            material.doubleSided = true; // 両面にテクスチャを貼る
            material.precise = true; // テクスチャの歪み防止
            
            // 平面を作成
            var plane:Plane = new Plane(material, 600, 600, 8);
            var plane2:Plane = new Plane(material, 600, 600, 8);
            plane.z = -110;
            plane2.rotationY = 90;
            
            // 画面を表示
            scene.addChild(plane);
            scene.addChild(plane2);
            
            // レンダリング開始
            startRendering();
            
            // ついでに回転でもさせておく
            addEventListener(Event.ENTER_FRAME, function():void {
                plane.yaw(1);
                plane2.yaw(1);
            });
        }
    }
}