/**
 * Copyright rafabarros ( http://wonderfl.net/user/rafabarros )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/ceiW
 */

package {
	
	import flash.display.Sprite;
	import flash.display.MovieClip;
	import flash.display.Loader;
	import flash.display.Bitmap;
	import flash.display.BitmapData;
	
	import flash.display.StageQuality;
	
	import flash.events.Event;
	import flash.events.MouseEvent;
	
	import flash.net.*;
	import com.bit101.components.HUISlider;
	
	import gs.TweenMax;
	
	public class FlashTest extends Sprite {

		private var player:Object;
		private var loader:Loader;
		
		private var holder_mc:Sprite;
		
		private var bmp:Bitmap;
		private var bmpD:BitmapData;
		
		private var frames_holder:Sprite;
		private var frames:Array = [];
		
		private var _w:Number = 320;
		private var _h:Number = 180;
		
		private var seeker:HUISlider;
		
		
		
		public function FlashTest(){		
			addEventListener(Event.ADDED_TO_STAGE, init);
			
		}
		
		
		private function init(ev : Event = null){
			
			removeEventListener(Event.ADDED_TO_STAGE, init);
			
			addChild( frames_holder = new Sprite() );
			addChild( holder_mc = new Sprite() );
			
			holder_mc.x = frames_holder.x = (stage.stageWidth - _w  ) / 2
			holder_mc.y = frames_holder.y = (stage.stageHeight - _h ) / 2
			
			frames_holder.alpha = 0;
			
			seeker = new HUISlider(this, 5, 5, 'seeker');
			seeker.width = 385;
			seeker.value = 0;
			
			seeker.x = (stage.stageWidth - _w - 18 )/2;
			seeker.y = (stage.stageHeight + 200 )/2;
			
			loader = new Loader();
			loader.contentLoaderInfo.addEventListener(Event.INIT, onLoaderInit);
			loader.load(new URLRequest("http://www.youtube.com/apiplayer?version=3"));
			
		}
		
		
		private function onLoaderInit(event:Event):void {
			
			holder_mc.addChild( loader );
			
			loader.content.addEventListener("onReady", onPlayerReady);
			loader.content.addEventListener("onError", onPlayerError);
			loader.content.addEventListener("onStateChange", onPlayerStateChange);
			
		}
		
		
		private function onPlayerReady(event:Event):void {
			
			player = loader.content;
			
			player.setSize(_w, _h);
			player.setVolume(0);
			
			player.loadVideoById('hG9PGF6SW1U', 0);
			player.playVideo();
			
			
			seeker.addEventListener(MouseEvent.MOUSE_DOWN, function(){ 
				
				player.stopVideo();
				
				for (var i:uint = 0; i < frames.length; i++ ) {
					
					frames[i].x = ( ( i - seeker.value ) * 280 ); 
					frames[i].rotationY = -20;
					
				}
				
				TweenMax.to(holder_mc, .1, { alpha:0 });
				TweenMax.to(frames_holder, .1, { alpha:1 });
				
			});
			
			
			seeker.addEventListener(Event.CHANGE, function(){ 
				
				for (var i:uint = 0; i < frames.length; i++ ) {
					
					frames[i].x = ( ( i - seeker.value ) * 280 ); 
					frames[i].rotationY = -20;
					
				}
				
				
			});
			
			
			stage.addEventListener(MouseEvent.MOUSE_UP, function(){  
				
				TweenMax.to(holder_mc, .3, { alpha:1 });
				TweenMax.to(frames_holder, .3, { alpha:0 });
				
				player.seekTo(Math.round(seeker.value)); 
				player.playVideo(); 
				
			});
			
			
		}
		
		
		private function onPlayerError(event:Event):void {
			
			trace("player error:", Object(event).data);
		
		}
		
		
		private function onPlayerStateChange(event:Event):void {
			
			trace("player state:", Object(event).data);
			
			if ( Number(Object(event).data) == 1 ){
				
				seeker.minimum = 0;
				seeker.maximum = player.getDuration();
				
				
				if ( frames[0] == null ){
					
					for (var i:Number = 0; i <= Number(player.getDuration()); i++ ) frames_holder.addChild( frames[i] = new FrameVideo( i ) );
					
				}
				
			}
			
			if ( Number(Object(event).data) == 1 ){
				
				addEventListener(Event.ENTER_FRAME, checkFrame);
				
			} else {
				
				removeEventListener(Event.ENTER_FRAME, checkFrame);
				
			}
			
		}
		
		
		private function checkFrame( ev : Event ){
			
			if ( !frames[Math.round(player.getCurrentTime())].isFilled ) 
				desenhar(Math.round(player.getCurrentTime()));
			
			seeker.value = player.getCurrentTime();
			
		}
		
		
		private function desenhar( n:Number ){
			
			trace('>>>' + n)
			
			bmpD = new BitmapData( _w, _h, false, 0x0);
			bmpD.draw(holder_mc);
			
			bmp = new Bitmap(bmpD);
			
			frames[n].saveImage( bmp );
			
		}
		
	}
}


import flash.display.Sprite;
import flash.display.Bitmap;
import flash.display.BitmapData;
import flash.display.Shape;

import flash.text.TextField;
import flash.text.TextFormat;

import flash.events.Event;
import flash.events.MouseEvent;

class FrameVideo extends Sprite {
	
	private var bmp:Bitmap;
	public var isFilled:Boolean = false;
	private var index:Number;
	
	public function FrameVideo( n:Number ){
		
		index = n;
		
		var _shape:Shape = new Shape();    
		var tf:TextField = new TextField();
		
		var txf:TextFormat = new TextFormat();
		txf.color = 0xFFFFFF;
		txf.size = 30;
		
		tf.defaultTextFormat = txf;
		tf.text = ( index <= 9 ) ? '0' + index : String(index);
		
		tf.x = 120;
		tf.y = 80;
		
		_shape.graphics.beginFill( 0x0 , 1 );
		_shape.graphics.lineTo( 320, 0);
		_shape.graphics.lineTo( 320, 180);
		_shape.graphics.lineTo(0, 180);
		_shape.graphics.lineTo(0, 0); 
		
		addChild(_shape);
		addChild(tf);
		
	}
	
	public function saveImage(b:Bitmap){
		
		isFilled = !isFilled;
		
		bmp = b;
		addChild(b);
		
	}
	
	
}


