/**
 * Copyright SquirrelKing ( http://wonderfl.net/user/SquirrelKing )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/cddt
 */

// forked from nanlow's misty
//ソース見難くてすいません。
//インデントつけたらエラーになったもので・・・。
package {
import flash.display.Bitmap;
import flash.display.BitmapData;
import flash.display.BlendMode;
import flash.display.Sprite;
import flash.events.Event;
import flash.events.TimerEvent;
import flash.filters.BlurFilter;
import flash.geom.ColorTransform;
import flash.geom.Matrix;
import flash.geom.Point;
import flash.geom.Rectangle;
import flash.utils.Timer;
[SWF(width = "480", height = "480", frameRate = "60")];
public class Main extends Sprite {
private const SEGMENT:uint = 10;
private const COUNT:uint = 30;
private const MAGNIFICATION:Number = 2;

private var _canvas:BitmapData;
private var _drawField:BitmapData;
private var _bm:Bitmap;
private var _container:Sprite;

private var _bezierPointList:/*BezierPoint*/Array = [];
private var _pointList:/*SimplePoint*/Array = [];
private var _colorList:/*uint*/Array = [];

public function Main():void {
addEventListener(Event.ADDED_TO_STAGE, _init);
}
private function _init(e:Event = null):void {
for (var i:int = 0; i < COUNT; i++) {
var bp:BezierPoint = new BezierPoint();
_layout(bp, i / COUNT);
bp.saveDefault();
_bezierPointList[i] = bp;
}
_canvas = new BitmapData(480, 480, false, 0x000000);
addChild(new Bitmap(_canvas));
_container = new Sprite();
addEventListener(Event.ENTER_FRAME, _onEnterFrameHandler);
var timer:Timer = new Timer(1000, 0);
timer.addEventListener(TimerEvent.TIMER, _onTimerHandler);
timer.start();
}
//初期レイアウト
private function _layout(bp:BezierPoint, percent:Number):void {
var r:Number = 50;
var h:Number = 10;
var rad:Number = 2 * Math.PI * percent;
bp.x = r * Math.cos(rad) + 240;
bp.y = r * Math.sin(rad) + 240;
bp.inPoint = new SimplePoint(h * Math.cos(Math.PI * 0.5 + rad) + bp.x, h * Math.sin(Math.PI * 0.5 + rad) + bp.y);
}
//配列からベジェ曲線を描画する
private function _drawBezier(arr:Array):void {
_container.graphics.clear();
_container.graphics.lineStyle(2, 0xFFFFFF, 1);
_container.graphics.moveTo(arr[0].x, arr[0].y);
for (var i:int = 1; i < arr.length; i++) {
_container.graphics.lineTo(arr[i].x, arr[i].y);
}
}
//2つのポイントデータからベジェ曲線用のポイントデータを配列に入れる
public function _lineTo(p0:BezierPoint, p1:BezierPoint):void {
var bezierSegment:BezierSegment = new BezierSegment(p0.ancherPont, p0.inPoint, p1.outPoint, p1.ancherPont);
_pointList.push(p0.ancherPont);
for (var i:int = 0; i < SEGMENT; i++) {
_pointList.push(bezierSegment.getValue(1 / SEGMENT * i));
}
_pointList.push(p1.ancherPont);
}
//ベジェ曲線
private function _draw():void {
for (var i:int = 0; i < _bezierPointList.length-1; i++) {
_lineTo(_bezierPointList[i], _bezierPointList[i+1]);
}
_lineTo(_bezierPointList[_bezierPointList.length - 1], _bezierPointList[0]);

_drawBezier(_pointList);
_pointList = [];

_drawField.draw(_container);
}
//エフェクトのフェード
private function _fade():void {
var mat:Matrix = new Matrix();
mat.translate( -240, -240);
mat.scale(MAGNIFICATION, MAGNIFICATION);
mat.rotate(0.03);
mat.translate(240, 240);
_canvas.draw(_drawField, mat);
_canvas.applyFilter(_canvas, _canvas.rect, new Point(), new BlurFilter(7, 7, 1));
_canvas.colorTransform(_canvas.rect, new ColorTransform(1, 1, 1, 1, _colorList[0], _colorList[1], _colorList[2], 0) );
var curtain:BitmapData = new BitmapData(480, 480, true, 0x01000000);
_canvas.draw(curtain);
}
//ベジェポイントを動かす
private function _move():void {
for (var i:int = 0; i < _bezierPointList.length; i++) {
BezierPoint(_bezierPointList[i]).move();
}
}
private function _onEnterFrameHandler(e:Event = null):void {
if (_drawField) {
_drawField.dispose();
}
_drawField = _canvas.clone();

_move();
_draw();
_fade();
}
private function _onTimerHandler(e:TimerEvent = null):void {
var h:Number = -7;
var b:Number = -0.5;
_colorList = [ h * Math.random() +b,h * Math.random() +b, h * Math.random() +b];
}
}
}
//ベジェ曲線用のポイントデータ
class BezierPoint {
private var _controllR:Number = 100;
private var _anchorR:Number = 10;

private var _controllRad:Number = 0;
private var _anchorRad:Number = 0;

private var _controllDefaultPoint:SimplePoint;
private var _anchorDefaultPoint:SimplePoint;

private var _aP:SimplePoint;
private var _cP0:SimplePoint;
private var _cP1:SimplePoint;

private var _x:Number;
private var _y:Number;

public function BezierPoint() {
_init();
}
private function _init():void {
_aP = new SimplePoint();
_cP0 = new SimplePoint();
_cP1 = new SimplePoint();
_controllRad = 2 * Math.PI * Math.random();
_anchorRad = 2 * Math.PI * Math.random();
}
//コントロールポイントの移動
private function _moveControll(controllPoint:SimplePoint):void {
var targetPoint:SimplePoint = (controllPoint == _cP0) ? _cP1 : _cP0;

targetPoint.x = _aP.x * 2 - controllPoint.x;
targetPoint.y = _aP.y * 2 - controllPoint.y;
}
public function saveDefault():void {
_controllDefaultPoint = new SimplePoint(inPoint.x, inPoint.y);
_anchorDefaultPoint = new SimplePoint(x, y);
}
public function move():void {
var speed:Number = 0.05 + 0.1 * Math.random();

_controllRad = (_controllRad + speed) % (2 * Math.PI);
_anchorRad = (_anchorRad + speed) % (2 * Math.PI);

inPoint.x = _controllR * Math.cos(_controllRad) +_controllDefaultPoint.x;
inPoint.y = _controllR * Math.sin(_anchorRad) +_controllDefaultPoint.y;
x = _anchorR * Math.cos(_anchorRad) +_anchorDefaultPoint.x;
y = _anchorR * Math.sin(_controllRad) +_anchorDefaultPoint.y;
}
public function get inPoint():SimplePoint {
return new SimplePoint(_cP0.x + x,_cP0.y + y);
}
public function set inPoint(value:SimplePoint):void {
_cP0.x = value.x - x;
_cP0.y = value.y - y;
_moveControll(_cP0);
}
public function get outPoint():SimplePoint {
return new SimplePoint(_cP1.x + x,_cP1.y + y);
}
public function set outPoint(value:SimplePoint):void {
_cP1.x = value.x - x;
_cP1.y = value.y - y;
_moveControll(_cP1);
}
public function get ancherPont():SimplePoint {
return new SimplePoint(x,y);
}

public function get x():Number {
return _x;
}
public function set x(value:Number):void {
_x = value;
}
public function get y():Number {
return _y;
}
public function set y(value:Number):void {
_y = value;
}
}
//fl.motion.BezierSegmentの代わり
class BezierSegment {
private var _anchor0:SimplePoint;
private var _anchor1:SimplePoint;
private var _controll0:SimplePoint;
private var _controll1:SimplePoint;
public function BezierSegment(anchor0:SimplePoint, controll0:SimplePoint, controll1:SimplePoint, anchor1:SimplePoint) {
_anchor0 = anchor0;
_anchor1 = anchor1;
_controll0 = controll0;
_controll1 = controll1;
}
public function getValue(per:Number):SimplePoint {
if (per < 0 || 1 < per) {
throw new Error(' 0≦per≦1でお願いしますm(_ _;)m');
}

//http://www.saoyagi.net/piece/bezier.html参考
var p:Number = 1 - per;
return new SimplePoint(p * p * p * _anchor0.x + 3 * p * p * per * _controll0.x + 3 * p * per * per * _controll1.x + per * per * per * _anchor1.x,p * p * p * _anchor0.y + 3 * p * p * per * _controll0.y + 3 * p * per * per * _controll1.y + per * per * per * _anchor1.y);
}
}
//簡易ポイントクラス
class SimplePoint {
private var _x:Number;
private var _y:Number;
public function SimplePoint(x:Number = 0, y:Number = 0) {
_x = x;
_y = y;
}
public function get x():Number {
return _x;
}
public function set x(value:Number):void {
_x = value;
}
public function get y():Number {
return _y;
}
public function set y(value:Number):void {
_y = value;
}
}




