/**
 * Copyright foo9 ( http://wonderfl.net/user/foo9 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/cdZg
 */

// forked from zahir's TextFieldにスクロールバーとかつけてみる

package{
	import flash.display.Sprite;
	import flash.text.TextField;
	import flash.events.Event;
	import flash.text.TextFieldType;
	
	//★
	import flash.text.Font;
	
	[SWF(width=465, height = 465, backgroundColor = 0xCCCCCC)]

	public class MyTextBox extends Sprite{
		private var t:TextField;
		private var scrollV:TextBoxVScrollBar;
		
		private var scrollBarWidth:int = 18;
		
		//★
		private var allFontList:Array
		
		public function MyTextBox(){
			t = new TextField();
			t.addEventListener(Event.ADDED, function(e:Event):void{
				var str:String = "";
				//for(var i:int = 1; i<= 100; i++){
				//	str +=  "Line " + String( i ) + " ::  " + "\n";
				//}
				
				//★
				// 使用できるフォント一覧
	             allFontList = Font.enumerateFonts(true);
	             allFontList.sortOn("fontName", Array.CASEINSENSITIVE);
	             for each(var f:Font in allFontList){
	                 str += f.fontName + "\n";
	             }
				
				t.text = str;
				
				t.width = t.maxScrollV > 0 ? stage.stageWidth - scrollBarWidth : stage.stageWidth;
				t.height = stage.stageHeight;
				
				t.wordWrap = true;
				t.type = flash.text.TextFieldType.DYNAMIC;
				
				if(t.maxScrollV > 1){
					scrollV = new TextBoxVScrollBar( t, scrollBarWidth, t.height );
					scrollV.x = t.width;
					addChild(scrollV);
				}
			});
			addChild(t);
		}
	}
}
	import flash.display.Sprite;
	import flash.text.TextField;
	import flash.display.Shape;
	import flash.display.Graphics;
	import flash.geom.Matrix;
	import flash.display.CapsStyle;
	import flash.events.*;

class TextBoxVScrollBar extends Sprite{
	private var t:TextField;
	private var w:int, h:int;
	
	// Line
	private var lineHeight:Number;
	
	// item
	private var up:UpArrow;
	private var down:DownArrow;
	private var top:TopArrow;
	private var bottom:BottomArrow;
	private var slider:TextBoxVSlider;
	
	public function TextBoxVScrollBar( target:TextField , width:int, height:int){
		t = target;
		w = width;
		h = height;
		lineHeight = t.textHeight / t.numLines;
		
		var m:Matrix = new Matrix();
		m.createGradientBox( w, h);
		
		var g:Graphics = this.graphics;
		g.lineStyle(0, 0x111111 );
		g.beginGradientFill( "linear", [ 0x999999, 0x777777],[1.0,1.0],[0,255],m);
		g.drawRect(0, 0, w, h );
		g.endFill()
		
		initGUI();
		
		t.addEventListener(Event.SCROLL, function(e:Event):void{
			slider.y = (t.scrollV -1) * lineHeight + minY;
		});
		
		this.addEventListener( MouseEvent.MOUSE_DOWN, function(e:MouseEvent):void{
			var pos:int = mouseY;
			if(pos <= minY) return;
			if(pos >= maxY + slider.height) return;
			if( pos >= slider.y && pos <= (slider.y + slider.height)) return
			
			if(pos >= maxY) pos -= slider.height;
			slider.y = pos;
			t.scrollV = int((pos - minY) / lineHeight) + 1;
		});
	}
	private function initGUI():void{
		up = new UpArrow( w );
		down = new DownArrow( w );
		top = new TopArrow( w );
		bottom = new BottomArrow( w );
		
		up.y = top.height;
		bottom.y = h - down.height;
		down.y = h - down.height - bottom.height;
		
		var d:Number = down.y - (up.y + up.height);
		d *= d/t.textHeight;
		slider = new TextBoxVSlider( w - 4, d );
		slider.y = minY = up.y + up.height;
		
		maxY = (down.y - d) + 2;
		lineHeight = (maxY - minY) / ( t.maxScrollV -1);
		
		addChild(slider);
		addChild( top );
		addChild( bottom );
		addChild( up );
		addChild( down );
		
		slider.addEventListener(MouseEvent.MOUSE_DOWN, function(e:MouseEvent):void{
			cY = slider.mouseY;
			slider.stage.addEventListener(MouseEvent.MOUSE_MOVE, onMove);
			slider.stage.addEventListener(MouseEvent.MOUSE_UP, offMove);
		});
		top.addEventListener(MouseEvent.CLICK, function(e:MouseEvent):void{
			t.scrollV = 1;
			slider.y = minY;
		});
		bottom.addEventListener(MouseEvent.CLICK, function(e:MouseEvent):void{
			t.scrollV = t.maxScrollV;
			slider.y = maxY;
		});
		up.addEventListener(MouseEvent.CLICK, function(e:MouseEvent):void{
			if( !(t.scrollV > 1) ) return
			t.scrollV = t.scrollV - 1;
			slider.y -= lineHeight;
			if(slider.y < minY) slider.y = minY;
		});
		down.addEventListener(MouseEvent.CLICK, function(e:MouseEvent):void{
			if( !(t.scrollV < t.maxScrollV) ) return
			t.scrollV = t.scrollV + 1;
			slider.y += lineHeight;
			if(slider.y > maxY) slider.y = maxY;
		});
	}
	private var cY:int;
	private var minY:int;
	private var maxY:int;
	private function onMove(e:MouseEvent):void{
		var yy:int = stage.mouseY - cY;
		if(yy <= minY) yy = minY;
		if(yy >= maxY) yy = maxY;
		slider.y = yy;
		t.scrollV = int((yy - minY) / lineHeight) + 1;
	}
	private function offMove(e:MouseEvent):void{
		slider.stage.removeEventListener(MouseEvent.MOUSE_MOVE, onMove);
		slider.stage.removeEventListener(MouseEvent.MOUSE_UP, offMove);
	}
}
class TextBoxVSlider extends Sprite{
	private var w:int, h:Number;
	private var w_2:int;
	private var md_flg:Boolean = false;
	private var g:Graphics;
	
	public function get SliderHeight():Number{
		return h;
	}
	public function set SliderHeight( value:Number ):void{
		h = value;
	}
	
	public function TextBoxVSlider( width:int, height:int ){
		w = width;
		h = height;
		w_2 = (w>>1) + 2;
		g = this.graphics;
		drawUp();
		this.addEventListener( MouseEvent.ROLL_OVER, function(e:MouseEvent):void{
			if(md_flg) return;
			drawOver();
			addEventListener( MouseEvent.ROLL_OUT, onOut);
		});
		
		this.addEventListener( MouseEvent.MOUSE_DOWN, function(e:MouseEvent):void{
			md_flg = true;
			drawDown();
			stage.addEventListener(MouseEvent.MOUSE_UP, onUp);
		});
	}
	private function onOut(e:MouseEvent):void{
		removeEventListener( MouseEvent.MOUSE_OUT, onOut);
		if(md_flg) return;
		drawUp();
	}
	private function onUp(e:MouseEvent):void{
		drawUp();
		stage.removeEventListener(MouseEvent.MOUSE_UP, onUp);
	}
	private function drawUp():void{
		g.clear();
		g.lineStyle( w, 0x333333, 1, true, "normal", flash.display.CapsStyle.ROUND);
		g.moveTo( w_2 , w_2);
		g.lineTo( w_2, h - w_2);
	}
	private function drawDown():void{
		g.clear();
		g.lineStyle( w , 0x0, 1, true, "normal", flash.display.CapsStyle.ROUND);
		g.moveTo( w_2 , w_2);
		g.lineTo( w_2, h - w_2);
		
		g.lineStyle( w-2, 0xFFFFFF, 1, true, "normal", flash.display.CapsStyle.ROUND);
		g.moveTo( w_2 , w_2);
		g.lineTo( w_2, h - w_2);
	}
	private function drawOver():void{
		g.clear();
		g.lineStyle( w, 0x111111, 1, true, "normal", flash.display.CapsStyle.ROUND);
		g.moveTo( w_2 , w_2);
		g.lineTo( w_2, h - w_2);
	}
}
class UpArrow extends Sprite{
	private var w:int, h:int;
	private var g:Graphics;
	private var flg:Boolean = false;
	public function UpArrow( size:int ){
		w = h = size;
		g = this.graphics;
		drawUp();
		this.addEventListener( MouseEvent.ROLL_OVER, function(e:MouseEvent):void{
			drawOver();
			flg = true;
		});
		this.addEventListener( MouseEvent.ROLL_OUT, function(e:MouseEvent):void{
			drawUp();
			flg = false;
		});
		
		this.addEventListener( MouseEvent.MOUSE_DOWN, function(e:MouseEvent):void{
			drawDown();
			stage.addEventListener(MouseEvent.MOUSE_UP, onUp);
		});
		
	}
	private function onUp(e:MouseEvent):void{
		flg ? drawOver() : drawUp();
		stage.removeEventListener(MouseEvent.MOUSE_UP, onUp);
	}
	private function drawUp():void{
		g.clear();
		g.lineStyle(0, 0x111111);
		g.beginFill( 0x333333 );
		g.drawRect( 0, 0, w, h );
		g.endFill();
		
		g.beginFill( 0xCCCCCC );
		g.moveTo( w/2, 5 );
		g.lineTo(3, h - 5 );
		g.lineTo( w - 3 , h- 5);
		g.endFill();
	}
	private function drawDown():void{
		g.clear();
		g.lineStyle(0, 0x0099FF);
		g.beginFill( 0x000000 );
		g.drawRect( 1, 1, w - 2, h -2  );
		g.endFill();
		
		g.lineStyle(0, 0x111111);
		g.beginFill( 0xFFFFFF );
		g.moveTo( w/2, 5 );
		g.lineTo(3, h - 5 );
		g.lineTo( w - 3 , h- 5);
		g.endFill();
	}
	private function drawOver():void{
		g.clear();
		g.lineStyle(0, 0x111111);
		g.beginFill( 0x333333 );
		g.drawRect( 0, 0, w, h );
		g.endFill();
		
		g.beginFill( 0xFFFFFF );
		g.moveTo( w/2, 5 );
		g.lineTo(3, h - 5 );
		g.lineTo( w - 3 , h- 5);
		g.endFill();
	}
}
class DownArrow extends Sprite{
	private var w:int, h:int;
	private var g:Graphics;
	private var flg:Boolean = false;
	public function DownArrow( size:int ){
		w = h = size;
		g = this.graphics;
		drawUp();
		
		this.addEventListener( MouseEvent.ROLL_OVER, function(e:MouseEvent):void{
			drawOver();
			flg = true;
		});
		this.addEventListener( MouseEvent.ROLL_OUT, function(e:MouseEvent):void{
			drawUp();
			flg = false;
		});
		
		this.addEventListener( MouseEvent.MOUSE_DOWN, function(e:MouseEvent):void{
			drawDown();
			stage.addEventListener(MouseEvent.MOUSE_UP, onUp);
		});
		
	}
	private function onUp(e:MouseEvent):void{
		flg ? drawOver() : drawUp();
		stage.removeEventListener(MouseEvent.MOUSE_UP, onUp);
	}
	private function drawUp():void{
		g.clear();
		g.lineStyle(0, 0x111111);
		g.beginFill( 0x333333 );
		g.drawRect( 0, 0, w, h );
		g.endFill();
		
		g.beginFill( 0xCCCCCC );
		g.moveTo( w/2,  h - 5 );
		g.lineTo(3, 5 );
		g.lineTo( w - 3 , 5);
		g.endFill();
	}
	private function drawDown():void{
		g.clear();
		g.lineStyle(0, 0x0099FF);
		g.beginFill( 0x000000 );
		g.drawRect( 1, 1, w-2, h-2 );
		g.endFill();
		
		g.lineStyle(0, 0x111111);
		g.beginFill( 0xFFFFFF);
		g.moveTo( w/2,  h - 5 );
		g.lineTo(3, 5 );
		g.lineTo( w - 3 , 5);
		g.endFill();
	}
	private function drawOver():void{
		g.clear();
		g.lineStyle(0, 0x111111);
		g.beginFill( 0x333333 );
		g.drawRect( 0, 0, w, h );
		g.endFill();
		
		g.beginFill( 0xFFFFFF);
		g.moveTo( w/2,  h - 5 );
		g.lineTo(3, 5 );
		g.lineTo( w - 3 , 5);
		g.endFill();
	}
}
class TopArrow extends Sprite{
	private var w:int, h:int;
	private var g:Graphics;
	private var flg:Boolean = false;
	public function TopArrow( size:int ){
		w = h = size;
		g = this.graphics;
		drawUp();
		
		this.addEventListener( MouseEvent.ROLL_OVER, function(e:MouseEvent):void{
			drawOver();
			flg = true;
		});
		this.addEventListener( MouseEvent.ROLL_OUT, function(e:MouseEvent):void{
			drawUp();
			flg = false;
		});
		
		this.addEventListener( MouseEvent.MOUSE_DOWN, function(e:MouseEvent):void{
			drawDown();
			stage.addEventListener(MouseEvent.MOUSE_UP, onUp);
		});
		
	}
	private function onUp(e:MouseEvent):void{
		flg ? drawOver() : drawUp();
		stage.removeEventListener(MouseEvent.MOUSE_UP, onUp);
	}
	private function drawUp():void{
		g.clear();
		g.lineStyle(0, 0x111111);
		g.beginFill( 0x333333 );
		g.drawRect( 0, 0, w, h );
		g.endFill();
		
		g.beginFill( 0xCCCCCC );
		g.moveTo( w/2, 3 );
		g.lineTo(4, 8 );
		g.lineTo( w - 4 , 8);
		
		g.moveTo( w/2, 10 );
		g.lineTo(4, h - 3 );
		g.lineTo( w - 4 , h - 3);
		g.endFill();
	}
	private function drawDown():void{
		g.clear();
		g.lineStyle(0, 0x00099FF);
		g.beginFill( 0x000000 );
		g.drawRect( 1, 1, w-2, h-2 );
		g.endFill();
		
		g.lineStyle(0, 0x333333);
		g.beginFill( 0xFFFFFF);
		g.moveTo( w/2, 3 );
		g.lineTo(4, 8 );
		g.lineTo( w - 4 , 8);
		
		g.moveTo( w/2, 10 );
		g.lineTo(4, h - 3 );
		g.lineTo( w - 4 , h - 3);
		g.endFill();
	}
	private function drawOver():void{
		g.clear();
		g.lineStyle(0, 0x111111);
		g.beginFill( 0x333333 );
		g.drawRect( 0, 0, w, h );
		g.endFill();
		
		g.beginFill( 0xFFFFFF );
		g.moveTo( w/2, 3 );
		g.lineTo(4, 8 );
		g.lineTo( w - 4 , 8);
		
		g.moveTo( w/2, 10 );
		g.lineTo(4, h - 3 );
		g.lineTo( w - 4 , h - 3);
		g.endFill();
	}
}
class BottomArrow extends Sprite{
	private var w:int, h:int;
	private var g:Graphics;
	private var flg:Boolean = false;
	public function BottomArrow( size:int ){
		w = h = size;
		g = this.graphics;
		drawUp();
		
		this.addEventListener( MouseEvent.ROLL_OVER, function(e:MouseEvent):void{
			drawOver();
			flg = true;
		});
		this.addEventListener( MouseEvent.ROLL_OUT, function(e:MouseEvent):void{
			drawUp();
			flg = false;
		});
		
		this.addEventListener( MouseEvent.MOUSE_DOWN, function(e:MouseEvent):void{
			drawDown();
			stage.addEventListener(MouseEvent.MOUSE_UP, onUp);
		});
		
	}
	private function onUp(e:MouseEvent):void{
		flg ? drawOver() : drawUp();
		stage.removeEventListener(MouseEvent.MOUSE_UP, onUp);
	}
	private function drawUp():void{
		g.clear();
		g.lineStyle(0, 0x111111);
		g.beginFill( 0x333333 );
		g.drawRect( 0, 0, w, h );
		g.endFill();
		
		g.beginFill( 0xCCCCCC );
		g.moveTo( w/2, 8 );
		g.lineTo(4, 3 );
		g.lineTo( w - 4 , 3);
		
		g.moveTo( w/2, h - 3 );
		g.lineTo(4,  10);
		g.lineTo( w - 4 , 10);
		g.endFill();
	}
	private function drawDown():void{
		g.clear();
		g.lineStyle(0, 0x00099FF);
		g.beginFill( 0x0 );
		g.drawRect( 1, 1, w-2, h-2 );
		g.endFill();
		
		g.lineStyle(0, 0x333333);
		g.beginFill( 0xFFFFFF );
		g.moveTo( w/2, 8 );
		g.lineTo(4, 3 );
		g.lineTo( w - 4 , 3);
		
		g.moveTo( w/2, h - 3 );
		g.lineTo(4,  10);
		g.lineTo( w - 4 , 10);
		g.endFill();
	}
	private function drawOver():void{
		g.clear();
		g.lineStyle(0, 0x111111);
		g.beginFill( 0x333333 );
		g.drawRect( 0, 0, w, h );
		g.endFill();
		
		g.beginFill( 0xFFFFFF );
		g.moveTo( w/2, 8 );
		g.lineTo(4, 3 );
		g.lineTo( w - 4 , 3);
		
		g.moveTo( w/2, h - 3 );
		g.lineTo(4,  10);
		g.lineTo( w - 4 , 10);
		g.endFill();
	}
}
