/**
 * Copyright TmskSt ( http://wonderfl.net/user/TmskSt )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/cdCS
 */

// forked from ksnmt's forked from: soundtest11
// forked from gaina's soundtest11
package 
{
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.geom.Point;
    import flash.media.Sound;
    import flash.media.SoundLoaderContext;
    import flash.media.SoundMixer;
    import flash.media.SoundTransform;
    import flash.net.URLRequest;
    import flash.utils.ByteArray;
    import flash.display.*;
    import flash.events.*;
    import flash.geom.*;
    import flash.media.*;
    import flash.text.*;
    
    /**
     * ...
     * @author nagai
     * sound by AlainMikuni
     * 
     */
    
    [SWF(width="465",height="465",frameRate=60)]
    public class Main extends Sprite 
    {
        private var sound:Sound;
        private static const RECT:Rectangle = new Rectangle(0, 0, 256, 400);
        private static const PLOT_HEIGHT:int = 200;
        private static const CHANNEL_LENGTH:int = 256;
        private static const COLORS:Vector.<uint> = Vector.<uint>([0x0000FF, 0x00FF00, 0x00FFFF, ,0xEEEEEE, 0xFF00FF, 0x00F0FF, 0x000FFF, 0x0F00FF, 0xF00FF, 0xF0F0FF]);
        private var bitmapData:BitmapData;
        private var bitmap:Bitmap;
        private var bytes:ByteArray;
        
        private var b:Number, l:Number, n:Number, c:uint, cc:int, f:TextField, s:String;
        
        public function Main():void 
        {
            if (stage) init();
            else addEventListener(Event.ADDED_TO_STAGE, init);
        }
        
        private function init(e:Event=null):void 
        {
            removeEventListener(Event.ADDED_TO_STAGE, init);
            PlaySound("http://www.takasumi-nagai.com/soundfiles/sound004.mp3");
        }
        
        private function PlaySound(url:String):void
        {
            sound = new Sound();
            var _context:SoundLoaderContext = new SoundLoaderContext(1000, true);
            sound.addEventListener(Event.COMPLETE, SoundLoadeComplete);
            sound.load(new URLRequest(url), _context);
        }
        
        private function SoundLoadeComplete(e:Event):void 
        {
            //Wonderfl.capture_delay(46);
            
            bitmapData = new BitmapData(465, 465, false, 0);
            bitmap = new Bitmap(bitmapData, PixelSnapping.NEVER, false);
            this.addChild(bitmap);
            
            f = new TextField();
            f.defaultTextFormat = new TextFormat(null, null, 0xFFFFFF);
            f.width = 200;
            f.x = 280; f.y = 100;
            this.addChild(f);
            
            addEventListener(Event.ENTER_FRAME, loop);
            sound.play(0, 10, new SoundTransform(0.7, 0));
        }
        
        private function loop(e:Event):void 
        {
            bytes = new ByteArray();
            SoundMixer.computeSpectrum(bytes, true, 0);

            bitmapData.unlock(RECT);
            bitmapData.fillRect(RECT, 0);
            
            b = 0, l = 1, n = 0, c = COLORS[0], cc = 0, s="";
            for (var i:int = 0; i < CHANNEL_LENGTH; i++) {
                n = (bytes.readFloat() * PLOT_HEIGHT);
                if (!n || !b || ( (b / l) / 0x10 < n && (b / l) * 0xFF> n) ) b += n, l += 1;
                else b = 0, l = 1, c = ccc(cc+=1), s+="■";
                
                if (i > 220 && i < 300) c = 0xFF0000;
                bitmapData.fillRect(new Rectangle(i, PLOT_HEIGHT - n, 1, n), c);
            }
            
            b = 0, l = 1, n = 0, c = COLORS[0], cc = 0, s+="\n";
            for (i = 0; i < CHANNEL_LENGTH; i++) {
                n = (bytes.readFloat() * PLOT_HEIGHT);
                if (!n || !b || ( (b / l) / 0x10 < n && (b / l) * 0xFF> n) ) b += n, l += 1;
                else b = 0, l = 1, c = ccc(cc+=1), s+="■";
                bitmapData.fillRect(new Rectangle(i, PLOT_HEIGHT * 2 - n, 1, n), c);
            }
            f.text = s;
            bitmapData.lock();
        }
        
        private function ccc(cc:int):uint {
            return (COLORS.length < cc) ? 0xFFFFFF : COLORS[cc];
        }
    }
    
}