/**
 * Copyright a24 ( http://wonderfl.net/user/a24 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/cd9V
 */

package  
{
  import flash.display.Sprite;
  
  [ SWF( width = "465" , height = "465" , backgroundColor = "0xFFFFFF" , frameRate = "60" ) ]
  
  public class Main extends Sprite
  {
    public function Main() 
    {
      Wonderfl.capture_delay( 20 );
      
      var _color:Array = new Array( 0xB8B0D2 , 0x7AC4E6 , 0xBEDB8A , 0xF7EF9A , 0xFACA90 , 0xEDBDD1 , 0xEC989A , 0xB8B0D2 , 0x7AC4E6 );

      for ( var j:int = 0; j < 8; j ++ ) 
      {
        for ( var i:int = 0; i < 14; i ++) 
        {
          var _tag:Sprite = createTag( _color[j] );
          _tag.x = 35 * i;
          _tag.y = -10 + 65 * j;
          
          // スウィングを適応
          var _swing:Swinger = new Swinger( _tag );
          _swing._force = 40; // 初期振り幅
          //_swing._minForce = 10; // 最小振り幅
          //_swing._maxForce = 60; // 最大振り幅
          _swing._mouseRate = 4;    // マウス感度
          _swing.startMouseEvent( stage ); // マウスに反応させる
          _swing.execute(); // 振り実行
        }
      }
    }
    
    private function createTag( color:uint ):Sprite
    {
      var _tag:Sprite = new Sprite();
      _tag.blendMode = "multiply";
      _tag.buttonMode = true;
      _tag.graphics.beginFill( color , 1.0 );
      _tag.graphics.moveTo( 0 , 0 );
      _tag.graphics.lineTo( 15 , 10 );
      _tag.graphics.lineTo( 15 , 60 );
      _tag.graphics.lineTo( -15 , 60 );
      _tag.graphics.lineTo( -15 , 10 );
      _tag.graphics.endFill();
      addChild( _tag );
      return _tag;
    }
  }
}







  import flash.display.Stage;
  import flash.display.DisplayObject;
  import flash.events.Event;
  import flash.events.MouseEvent;
  
  class Swinger 
  {
    public var _target:DisplayObject;
    
    public var _force:Number = 0;        // 力
    public var _friction:Number = 0.02; // 摩擦係数
    public var _speed:Number = 0.12;   // 位相速度
    public var _phase:Number = 0;      // 位相
    
    private var _stage:Stage;
    private var _x1:Number;
    private var _x2:Number;
    private var _extrForce:Number;       // マウスから受けた力
    public var _minForce:Number;         // 最小振り幅
    public var _maxForce:Number;        // 最大振り幅
    public var _mouseRate:Number = 1; // マウス力レート
    
    public function Swinger( _target:DisplayObject) 
    {
      this._target = _target;
    }
    
    /*
     * ------------------------------------------------------------
     * 実行
     * ------------------------------------------------------------
     */
    public function execute():void
    {
      _target.addEventListener( Event.ENTER_FRAME , rendering );
    }
    
    private function rendering( e:Event ):void
    {
      _phase += _speed;
      
      // マウスから力を受けた時
      if ( _extrForce && _force < _extrForce )
      {
        _force += ( _extrForce - _force ) / 4;
        if ( _extrForce - _force < 1 ) _extrForce = 0;
      }
      else _force = _force * ( 1 - _friction );
      
      var _rotation:Number = Math.cos( _phase ) * _force;
      
      // 振り切った時
      if ( _rotation > 180 || _rotation < -180 )
      {
        if ( _rotation > 180 ) _phase = Math.PI;
        if ( _rotation < -180 ) _phase = 0;
        
        _force = 180;
        _extrForce = 0;
      }
      _target.rotation = _rotation;
      
      // 止まりかけた時
      if ( _force < 0.1 )
      {
        _force = 0;
        _target.rotation = 0;
        _target.removeEventListener( Event.ENTER_FRAME , rendering );
      }
    }
    
    /*
     * ------------------------------------------------------------
     * マウス処理
     * ------------------------------------------------------------
     */
    public function startMouseEvent( _stage:Stage ):void
    {
      this._stage = _stage;
      _x1 = _x2 = 0;
      _target.addEventListener( Event.ENTER_FRAME , mouseMoveHandler );
      _target.addEventListener( MouseEvent.ROLL_OVER , mouseOverHandler );
    }
    
    public function stopMouseEvent():void
    {
      _target.removeEventListener( Event.ENTER_FRAME , mouseMoveHandler );
      _target.removeEventListener( MouseEvent.ROLL_OVER , mouseOverHandler );
    }
    
    private function mouseMoveHandler( e:Event ):void 
    {
      _x2 = _x1;
      _x1 = _stage.mouseX;
    }
    
    private function mouseOverHandler( e:MouseEvent ):void 
    {
      _extrForce = Math.abs( _x1 - _x2 ) * _mouseRate;
      if ( _extrForce && _minForce && _minForce > _extrForce ) _extrForce = _minForce;
      if ( _extrForce && _maxForce && _maxForce < _extrForce ) _extrForce = _maxForce;
      execute();
    }
    
    private function getState():int
    {
      return Math.floor( _phase * 2 / Math.PI ) % 4;
    }
  }
