/**
 * Copyright yangliu9812 ( http://wonderfl.net/user/yangliu9812 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/ccE7
 */

// forked from ShipNK's Visualization - Open Or Close
package {
    import flash.text.TextField;
    import flash.net.URLRequest;
    import flash.media.Sound;
    import flash.system.Security;
    import flash.display.Sprite;
    import flash.display.Bitmap;
    import flash.display.Shape;
    import flash.utils.ByteArray;
    import flash.media.SoundMixer;
    import flash.events.Event;
    import flash.display.Sprite;
    import flash.geom.ColorTransform;
    import flash.display.BitmapData;
    
    [SWF(backgroundColor=0)]
    
    public class FlashTest extends Sprite {
        
        private var tf:TextField = new TextField();
        private var bgm:Sound = new Sound();
        private var paper:BitmapData = new BitmapData( 100, 100, true, 0 );
        private var releaser:Boolean = true;
        private var i:int;
        private var j:int;
        private var shape:Shape = new Shape();
        private var shapes:Array = new Array();
        private var sprite:Sprite = new Sprite();
        private var byte:ByteArray = new ByteArray();
        private var soundPower:Number;
        private var color:ColorTransform;
        private var rects:Sprite = new Sprite();
        
        public function FlashTest() {
            tf.text = "BGM Loading...";
            addChild( tf );
            Security.loadPolicyFile( "http://joyfl.kr/shipworld/crossdomain.xml" );
            
            this.addChild( rects );
            for( i = 0; i < 5; ++ i )
            {
             for( j = 0; j < 5; ++ j )
             {
              shape = new Shape();
              shape.graphics.beginBitmapFill( paper );
              shape.graphics.drawRect( 0, 0, 100, 100 );
              shape.x = i * 100;
              shape.y = j * 100;
              if( i % 2 == 1 )
              {
               shape.scaleX *= -1;
               shape.x += 100;
              }
              if( j % 2 == 1 )
              {
               shape.scaleY *= -1;
               shape.y += 100;
              }
              rects.addChild( shape );
             }
            }
            stage.addEventListener( Event.ENTER_FRAME, process );
        }
        
        private function completeEvent( e:Event ) :void
        {
            bgm.play( 0, 100000 );
            removeChild( tf );
        }

        
        private function process ( e:Event ) :void
        {
         paper.lock();
         SoundMixer.computeSpectrum( byte, true, 0 );
         soundPower = byte.readFloat();
         //
         for( i = 0; i < soundPower * 3; ++ i )
         {
          shape = new Shape();
          shape.graphics.beginFill( 0xffffff - Random( 10000 ) );
          switch( Random( 2 ) )
          {
           case 0 :
           shape.graphics.drawCircle( 0, 0, byte.readFloat() * 10 );
           break;
           case 1 :
           shape.graphics.drawRect( 0, 0, byte.readFloat() * 10, byte.readFloat() * 10 );
           shape.rotation = Random( 360 );
           break;
          }
          shape.x = -10;
          shape.y = Random( 100 );
          shape.alpha = soundPower
          shapes.push ( shape );
          sprite.addChild( shape );
         }
         for( i = shapes.length - 1; i > -1; -- i )
         {
          shape.scaleY *= 0.95;
          shape.scaleX = shape.scaleY;
          shapes[ i ].x += soundPower * 5 + 1;
          if( releaser )
          {
           shapes[ i ].y += ( shapes[ i ].y - 50 ) * soundPower / 10;
          }
          else
          {
           shapes[ i ].y -= ( shapes[ i ].y - 50 ) * soundPower / 10;
          }
          if( shapes[ i ].x > 110 )
          {
           sprite.removeChild( shapes[ i ] );
           shapes.splice( i , 1 );
          }
         }
         //
         if( soundPower > 1 )
         {
          paper.perlinNoise( 100, 100, Random( 5 ), Random( 100 ), true, true, 7 );
          releaser = !releaser;
          color = new ColorTransform( 1, 1, 0, 0.9 );
         }
         else
         {
          color = new ColorTransform( 0, 1, 1, 0.8 );
         }
         //
         paper.colorTransform( paper.rect, color );
         paper.draw( sprite );
         paper.unlock();
        }
        private function Random( n:Number ) :int
        {
         return int( n * Math.random() );
        }
    }
}