/**
 * Copyright KinkumaDesign ( http://wonderfl.net/user/KinkumaDesign )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/ccCF
 */

/*
 * BetweenAS3で、Matrix　と ColorTransformのTweenの表記が
 * 面倒なのでBetweenAS3用に簡単に変換できるユーティリティを作りました
 */
package  
{
	import flash.display.Graphics;
	import flash.display.Sprite;
	import flash.display.StageAlign;
	import flash.display.StageScaleMode;
	import flash.events.Event;
	import flash.events.MouseEvent;
	import flash.geom.ColorTransform;
	import flash.geom.Matrix;
	import flash.text.TextField;
	import flash.text.TextFormat;
	import org.libspark.betweenas3.BetweenAS3;
	import org.libspark.betweenas3.easing.*;
	import org.libspark.betweenas3.tweens.ITween;
	/**
	 * ...
	 * @author KinkumaDesign
	 */
	public class Main extends Sprite
	{
		private var _matrixSP:Sprite;
		private var _colorTransSP:Sprite;
		
		private var _matrixTw:ITween;
		private var _colorTransTw:ITween;
		
		public function Main() 
		{
			addEventListener(Event.ADDED_TO_STAGE, init);
		}
		
		private function init(e:Event):void 
		{
			removeEventListener(Event.ADDED_TO_STAGE, init);
			
			stage.scaleMode = StageScaleMode.NO_SCALE;
			stage.align = StageAlign.TOP_LEFT;
			
			_matrixSP = generateSP();
			_colorTransSP = generateSP();
			
			addChild(_matrixSP);
			_matrixSP.x = 100;
			_matrixSP.y = 200;
			
			var tff:TextFormat = new TextFormat();
			tff.size = 12;
			var tf:TextField = new TextField();
			tf.text = "Matrix";
			tf.setTextFormat(tff);
			tf.selectable = false;
			tf.mouseEnabled = false;
			addChild(tf);
			tf.x = 100;
			tf.y = 180;
			
			addChild(_colorTransSP);
			_colorTransSP.x = 300;
			_colorTransSP.y = 200;
			
			tf = new TextField();
			tf.text = "ColorTransform";
			tf.setTextFormat(tff);
			tf.selectable = false;
			tf.mouseEnabled = false;
			addChild(tf);
			tf.x = 300;
			tf.y = 180;
			
			initMatrixTween();
			initColorTransformTween();
			_matrixSP.addEventListener(MouseEvent.CLICK, matrixSpClickHD);
			_colorTransSP.addEventListener(MouseEvent.CLICK, colorTransClickHD);
		}
		
		private function initColorTransformTween():void
		{
			var color1:ColorTransform = new ColorTransform(1, 1, 1, 1, -200, 200, 0, 0);
			var color2:ColorTransform = new ColorTransform();
			
			//こんな感じにつかいます
			var start:Object = BetweenAS3ObjectUtil.getColorTransformObj(color2);
			var end:Object = BetweenAS3ObjectUtil.getColorTransformObj(color1);
			
			_colorTransTw = BetweenAS3.tween(_colorTransSP, end, start, 1, Quad.easeIn);
		}
		
		private function initMatrixTween():void
		{
			var mtx:Matrix = new Matrix();
			var hw:Number = _matrixSP.width / 2;
			var hh:Number = _matrixSP.height / 2;
			mtx.translate(-hw, -hh);
			mtx.rotate(Math.PI * 45 / 180);
			mtx.scale(4, 4);
			mtx.translate(hw + _matrixSP.x, hh + _matrixSP.y);
			
			var mtx2:Matrix = _matrixSP.transform.matrix;
			
			//こんな感じにつかいます
			var start:Object = BetweenAS3ObjectUtil.getMatrixObj(mtx2);
			var end:Object = BetweenAS3ObjectUtil.getMatrixObj(mtx);
			
			_matrixTw = BetweenAS3.tween(_matrixSP, end, start, 1, Back.easeOut);
		}
		
		private function colorTransClickHD(e:MouseEvent):void 
		{
			if(_colorTransTw.isPlaying == false){
				_colorTransTw.gotoAndPlay(0);
			}
		}
		
		private function matrixSpClickHD(e:MouseEvent):void 
		{
			if(_matrixTw.isPlaying == false){
				_matrixTw.gotoAndPlay(0);
			}
		}
		
		private function generateSP():Sprite
		{
			var sp:Sprite = new Sprite();
			var g:Graphics = sp.graphics;
			g.beginFill(0xff0000, 1);
			g.drawRect(0, 0, 50, 50);
			g.endFill();
			return sp;
		}
	}

}

	import flash.geom.ColorTransform;
	import flash.geom.Matrix;

 class BetweenAS3ObjectUtil
	{		
		public static function getMatrixObj(mtx:Matrix):Object
		{
			return {transform:{matrix:{a:mtx.a, b:mtx.b, c:mtx.c, d:mtx.d, tx:mtx.tx, ty:mtx.ty}}}
		}
		
		public static function getColorTransformObj(trans:ColorTransform):Object
		{
			var rm:Number = trans.redMultiplier;
			var gm:Number = trans.greenMultiplier;
			var bm:Number = trans.blueMultiplier;
			var am:Number = trans.alphaMultiplier;
			var ro:Number = trans.redOffset;
			var go:Number = trans.greenOffset;
			var bo:Number = trans.blueOffset;
			var ao:Number = trans.alphaOffset;
			return {
				transform: {
					colorTransform: {
						redMultiplier:rm,
						greenMultiplier:gm,
						blueMultiplier:bm,
						alphaMultiplier:am,
						redOffset:ro,
						greenOffset:go,
						blueOffset:bo,
						alphaOffset:ao
					}
				}
			}
		}
	}