/**
 * Copyright bradsedito ( http://wonderfl.net/user/bradsedito )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/cbkZ
 */


// Brad Sedito 2011
// FF @beryu


package 
{
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.GradientType;
    import flash.display.Sprite;
    import flash.display.StageScaleMode;
    import flash.events.Event;
    import flash.filters.BlurFilter;
    import flash.filters.GlowFilter;
    import flash.filters.BitmapFilterQuality;
    import flash.geom.Matrix;
    import com.greensock.*;
    import com.greensock.easing.*;
    import net.hires.debug.Stats;
    
    [SWF(backgroundColor="0x000000", frameRate="90")]
  //[SWF(backgroundColor="0xFFFFFF", frameRate="90")]

    public class FlowLights extends Sprite {
        public  const SW:Number = new Number( stage.stageWidth  ); 
        public  const SH:Number = new Number( stage.stageHeight ); 
        private const LIGHT_LENGTH:int = 10; 
        private const LIGHT_WIDTH:int = SH / 2; 
        private var _stageSize:Array;
        private var _lights:Array;
        public var stats:Stats = new Stats();
        
        public function FlowLights() 
        {
            stage.scaleMode=StageScaleMode.NO_SCALE
            _stageSize = [stage.stageWidth, stage.stageHeight];
            
            var i:int;
            var light:Light;
            var bmd:BitmapData;
            var sprite:Sprite;
            var random:Number;
            var blurr:BlurFilter;//337BFF
            var gloww:GlowFilter;//337BFF
            var blurWidth:int;
            var matrix:Matrix = new Matrix();
            var width:int;
            _lights = [];
            for(i = 1; i < LIGHT_LENGTH; i++)
            {
                random = 1 / (LIGHT_LENGTH) * i;
                light = new Light();
                sprite = new Sprite();
    
                var rC:uint = new uint(Math.random()*0xFFFFFF);                
                
                width = random * LIGHT_WIDTH;
                matrix.createGradientBox(width, width/2, Math.PI / 2, 0, 0);
                sprite.graphics.beginGradientFill(
                        GradientType.RADIAL, 
                        [
                            int(random * 0x7) * rC, // 0x222222 + 0x191500,
                            int(random * 0x7) * rC, // 0x222222 + 0x191500
                        ],
                        [1, 1-random], 
                        [0, 255], 
                        matrix);
                sprite.graphics.drawCircle(0, 0, width / 2);
                sprite.graphics.endFill();
                
                blurWidth = int(2 / random) * 8;
                blurr = new BlurFilter(blurWidth, blurWidth, BitmapFilterQuality.HIGH);
                gloww = new GlowFilter(0x337BFF, .9, 10,10, 2,1, false,true);
                sprite.filters = [blurr, gloww];
                light.increment = random * 3 + 1;
                
                bmd = new BitmapData(width + blurWidth*2, width + blurWidth*2, true, 0); 
                bmd.draw(sprite, new Matrix(1, 0, 0, 1, (width + blurWidth*2) / 2, (width + blurWidth*2) / 2));
                
                light.bitmapData = bmd;
                light.visible = true;
                light.x = Math.random() * _stageSize[0] - light.width / 2;
                light.y = Math.random() * _stageSize[1] - light.height / 2;
                light.alpha = 0.01;
                addChild(light);
                _lights.push(light);
            }
            
            addEventListener(Event.ENTER_FRAME, loop);
            addEventListener(Event.RESIZE, onResize);
        }
        
        private function loop(e:Event):void
        {
            addChild(stats);
            _lights.blendMode = "add";

            var i:int;
            var blurFilter:BlurFilter;
            var blurWidth:int;
          //for(i = 0; i < LIGHT_LENGTH - 1; i++)
            for(i = 0; i < LIGHT_LENGTH - 1; i++)
            for(i = _lights.length - 1; i >= 0; i--)
            {
                if(!_lights[i].visible)
                {
                    var MainTL:TimelineMax = new TimelineMax({timeScale:1});
                    MainTL.append(
                        TweenMax.to(_lights[i], 1, {
                            x:Math.random() * _stageSize[0] - _lights[i].width  / 2,
                            y:Math.random() * _stageSize[1] - _lights[i].height / 2,                  
                            ease:Cubic.easeInOut})
                    );
                    
//                  _lights[i].x = Math.random() * _stageSize[0] - _lights[i].width / 2;
//                  _lights[i].y = (Math.random() * _stageSize[1]) - _lights[i].height / 2;
                    _lights[i].visible = true;
                }
                else if(_lights[i].y < 0 - _lights[i].height)
                {
                    _lights[i].visible = false;
                    _lights[i].alpha = 0;
                }
                else
                {
                    if(_lights[i].alpha < 1)
                    {
                        _lights[i].alpha += 0.01;
                    }
                    _lights[i].y -= _lights[i].increment;
                }
            }
        }
        
        private function onResize(e:Event):void
        {
            _stageSize = [stage.stageWidth, stage.stageHeight];
        }
    }
}



import flash.display.Sprite;
import flash.display.Bitmap;
class Light extends Bitmap
{
    public var increment:Number = 10;
  //public var increment:Number = 1;
}