/**
 * Copyright fyll_s ( http://wonderfl.net/user/fyll_s )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/caQn
 */

// forked from HaraMakoto's Arpeggiatorを使う
package
{
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.text.TextField;
    
    import org.si.sion.SiONData;
    import org.si.sion.SiONDriver;
    import org.si.sion.events.SiONEvent;
    import org.si.sion.utils.Scale;
    import org.si.sion.utils.SiONPresetVoice;
    import org.si.sound.Arpeggiator;
    
    [SWF(width="465", height="465", backgroundColor="#000000", frameRate=60)]
    public class UseArpeggiator extends Sprite
    {
        private var arpeggiator:Arpeggiator;
        public  var driver:SiONDriver = new SiONDriver();
        private var rythmLoop:SiONData;
        private var presetVoice:SiONPresetVoice = new SiONPresetVoice();
        
        private var px:Number = 0;
        private var py:Number = 0;
        
        // Let's try and do it Mtl-style
        private var arpPattern:Array = [0,1,2,5,4,3];
        
        private var text:TextField;
        
        
        public function UseArpeggiator() {
            initSound();
            soundStart();
            
            text = addChildAt(new TextField(), 0) as TextField;
            text.text = "(move your mouse around inside this black area)";
            text.border = false;
            text.x = 10;
            text.y = 10;
            text.width = 300;
            text.textColor = 0xFFFFFF;
        }
        
        
        private function initSound():void {
            var mml:String = "t132;";
            rythmLoop = driver.compile(mml);
            rythmLoop.setVoice(0, presetVoice["valsound.percus1"]);
            
            arpeggiator = new Arpeggiator(new Scale("o1Ajap"), 1, arpPattern);
            arpeggiator.voice = presetVoice["valsound.piano8"];
            arpeggiator.quantize = 4;
            arpeggiator.volume = 0.3;
            arpeggiator.noteQuantize = 8;
            
            driver.addEventListener(SiONEvent.STREAM, onStreamHandler);
            driver.play(rythmLoop);
            
            arpeggiator.pattern = arpPattern;
        }
        
        
        private function onStreamHandler(e:SiONEvent):void {
            // update arpeggiator pitch and length
            setPxPy();
            
            arpeggiator.scaleIndex = px * 32;
            arpeggiator.noteLength = [0.5,1,1,2,4][int(py * 4 + 0.99)];
        }
        
        public function soundStart():void {
            setPxPy();
            arpeggiator.scaleIndex = px * 32;
            arpeggiator.noteLength = [0.5,1,1,2,4][int(py * 4 + 0.99)];
            // start arpeggio
            arpeggiator.play();
        }
        
        private function setPxPy():void {
            px = mouseX / 465;
            py = mouseY / 465;
            
            if (px < 0)
                px = 0;
            else if (px > 0.9)
                px = 0.9;
            if (py < 0)
                py = 0;
            else if (py > 0.9)
                py = 0.9;
        }

    }
}