/**
 * Copyright yoshimax ( http://wonderfl.net/user/yoshimax )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/caOS
 */

package {
    import flash.events.*;
    import org.papervision3d.materials.*;
    import org.papervision3d.materials.special.CompositeMaterial;
    import org.papervision3d.objects.primitives.Plane;
    import org.papervision3d.view.BasicView;
    import org.libspark.betweenas3.BetweenAS3;
    import org.libspark.betweenas3.tweens.ITween;
    import org.libspark.betweenas3.easing.*;

    public class Main35 extends BasicView {

        static private const OBJ_NUM :int = 150;

        public function Main35() {

            for (var i:int = 0; i < OBJ_NUM; i++) {
                var pMat:CompositeMaterial = new CompositeMaterial();
                pMat.addMaterial(new ColorMaterial(Math.floor(Math.random() * 0xFFFFFF), 0.6));
                pMat.doubleSided = true;
                var plane:Plane = new Plane( pMat, 50, 50, 5, 5 );
                plane.name = "plane" + String(i);
                scene.addChild( plane );
                plane.rotationX = 360 * Math.random();
                plane.x = 1500 * Math.random() - 750;
                var sec:Number = 10 * Math.random() + 3;
                BetweenAS3.tween(plane, { y:-1400 }, { y:2000 - (200 * Math.random()) }, sec).play();
                BetweenAS3.tween(plane, { $z:-300}, { $z:300 }, sec/2).play();
                BetweenAS3.tween(plane, { $rotationX:-200}, { $rotationX:200 }, sec/2).play();
                BetweenAS3.tween(plane, { $rotationZ:-200}, { $rotationZ:200 }, sec/2).play();
                BetweenAS3.tween(plane, { $rotationY:-200}, { $rotationY:200 }, sec/2).play();
            }

            stage.quality = "medium";
            stage.frameRate = 60;

            viewport.opaqueBackground = 0xffffff;
            camera.zoom = 1;
            camera.focus = 200;
            startRendering();

        }
    }
}
