/**
 * Copyright John_Blackburne ( http://wonderfl.net/user/John_Blackburne )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/ca3D
 */

package
{	
	import flash.text.TextField;
	import flash.text.TextFieldAutoSize;
	import flash.display.Sprite;
	import flash.utils.getTimer;
	import flash.utils.setTimeout;

	// SWF Metadata
	[SWF(width = "500", height = "800", backgroundColor = "#ffffff", framerate = "31")]

	/**
	* ...
	* @author Hannes Moser
	*/
	public class VectorSpeedFP10Test extends Sprite {

		protected var result:TextField;
		protected var objectPoolA:Array;
		protected var objectPoolV:Vector.<Sprite>;
		protected const N_TEST:uint = 1000000;
		
		public function VectorSpeedFP10Test()
		{
			this.initialize();
		}
		
		/**
		 * initialize
		 */
		protected function initialize():void
		{
			result = new TextField();
			result.autoSize = TextFieldAutoSize.LEFT;
			result.multiline = true;
			result.wordWrap = true;
			this.addChild(result);
			
			objectPoolA = new Array();
			objectPoolV = new Vector.<Sprite>();
			var i:uint = 0;
			var s:Sprite = new Sprite();
			while (i < N_TEST)
			{
				objectPoolA[i] = s;
				objectPoolV[i] = s;
				
				i++;
			}
			
			run();
		}
		
		protected function run():void
		{
//			setTimeout(this.runWriteArrayTest, 1000);
			
//			setTimeout(this.runWriteVectorTest, 3000);
			
//			setTimeout(this.runReadVectorTest, 5000);
			
//			setTimeout(this.runReadArrayTest, 7000);
			
//			setTimeout(this.runOperationVectorTest, 9000);
			
//			setTimeout(this.runOperationArrayTest, 11000);
			
			setTimeout(this.runComplexOperationVectorTest, 3000);
			
			setTimeout(this.runComplexOperationArrayTest, 12000);
			
//			setTimeout(this.finished, 22000);
		}
		
		protected function finished():void
		{
			result.htmlText += "<br />Test Complete";
		}
		
		/**
		 * run
		 */
		
		 // vector write
		protected function runWriteVectorTest():void
		{
			var i:uint = 0;
			var n:uint = N_TEST;
			
			var v:Vector.<uint> = new Vector.<uint>(N_TEST);
			
			var timestamp:int = getTimer();
			
			while (i < n)
			{
				v.push(i);
				
				i++;
			}
			
			result.htmlText += "<br />Result Vector Write Test: " + (getTimer() - timestamp);
		}
		
		// arry write
		protected function runWriteArrayTest():void
		{
			var i:uint = 0;
			var n:uint = N_TEST;
			
			var v:Array = new Array();
			
			var timestamp:int = getTimer();
			
			while (i < n)
			{
				v.push(i);
				
				i++;
			}
			
			result.htmlText += "<br />Result Array Write Test: " + (getTimer() - timestamp);
		}
		
		// vector read
		protected function runReadVectorTest():void
		{
			var i:uint = 0;
			var n:uint = N_TEST;
			
			var v:Vector.<uint> = new Vector.<uint>(N_TEST);
			
			while (i < n)
			{
				v.push(i);
				
				i++;
			}
			
			var timestamp:int = getTimer();
			
			i = 0;
			var r:uint;
			while (i < n)
			{
				r = v[i];
				i++;
			}			
			
			result.htmlText += "<br />Result Vector Read Test: " + (getTimer() - timestamp);
		}		
		
		// array read
		protected function runReadArrayTest():void
		{
			var i:uint = 0;
			var n:uint = N_TEST;
			
			var v:Array = new Array();
			
			while (i < n)
			{
				v.push(i);
				
				i++;
			}
			
			var timestamp:int = getTimer();
			
			i = 0;
			var r:uint;
			while (i < n)
			{
				r = v[i];
				i++;
			}
			
			result.htmlText += "<br />Result Array Read Test: " + (getTimer() - timestamp);
		}
		
		// vector operation
		protected function runOperationVectorTest():void
		{
			var i:uint = 0;
			var n:uint = N_TEST;
			
			var v:Vector.<uint> = new Vector.<uint>(N_TEST);
			
			while (i < n)
			{
				v.push(i);
				i++;
			}
			
			var timestamp:int = getTimer();
			
			i = 0;
			var r:uint;
			while (i < n)
			{
				r = v[i];
				v[i] = r + r + r;
				i++;
			}			
			
			result.htmlText += "<br />Result Vector Operation Test: " + (getTimer() - timestamp);
		}		
		
		// array opperation
		protected function runOperationArrayTest():void
		{
			var i:uint = 0;
			var n:uint = N_TEST;
			
			var v:Array = new Array();
			
			while (i < n)
			{
				v.push(i);
				
				i++;
			}
			
			var timestamp:int = getTimer();
			
			i = 0;
			var r:uint;
			while (i < n)
			{
				r = v[i];
				v[i] = r + r + r;
				i++;
			}
			
			result.htmlText += "<br />Result Array Operation Test: " + (getTimer() - timestamp);
		}
		
		// vector complex operation
		protected function runComplexOperationVectorTest():void
		{
			var i:uint = 0;
			var n:uint = N_TEST;
			
			var v:Vector.<Sprite>;
			
			v = this.objectPoolV;
			
			i = 0;
			var r:Sprite;
			var x:Number;
			var y:Number;
			var z:Number;
			
			//var tmpS:Sprite = new Sprite();
			
			var timestamp:int = getTimer();
			while (i < n)
			{
				v[i].x += 100;
				v[i].y += 100;
				v[i].z += 100;
				//r = v[i];
				//r = Sprite(v[i]);
				//r.x += 100;
				//r.y += 100;
				//r.z += 100;
				
				i++;
			}			
			
			result.htmlText += "<br />Result Vector Complex Operation Test: " + (getTimer() - timestamp);
		}		
		
		// array opperation
		protected function runComplexOperationArrayTest():void
		{
			var i:uint = 0;
			var n:uint = N_TEST;
			
			var v:Array;

			v = this.objectPoolA;			
			
			i = 0;
			var r:Sprite;
			var x:Number;
			var y:Number;
			var z:Number;
			
			//var tmpS:Sprite = new Sprite();
			
			var timestamp:int = getTimer();
			while (i < n)
			{
				v[i].x += 100;
				v[i].y += 100;
				v[i].z += 100;
				//r = v[i];
				//r = Sprite(v[i]);
				//r.x += 100;
				//r.y += 100;
				//r.z += 100;
				
				i++;
			}			
			
			result.htmlText += "<br />Result Array Complex Operation Test: " + (getTimer() - timestamp);
		}		
		
	}
	
}