/**
 * Copyright umhr ( http://wonderfl.net/user/umhr )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/cZzi
 */

package {
	import flash.display.Sprite;
	import flash.text.TextField;
	

	/**
	 * ...
	 * @author umhr
	 */
	[SWF(backgroundColor="#F9F9F9")]
	public class Main extends Sprite {
		
		public function Main():void {
			var tf1:TextField = new TextField();
			tf1.text = "フォーカスが外れると、カンマをつける";
			tf1.autoSize = "left";
			tf1.x = 50;
			tf1.y = 30;
			addChild(tf1);
			var tfFocusOut:DigitTextFieldFocusOut = new DigitTextFieldFocusOut();
			tfFocusOut.x = 50;
			tfFocusOut.y = 50;
			tfFocusOut.text = "1234567"
			tfFocusOut.border = true;
			tfFocusOut.borderColor = 0x999999;
			tfFocusOut.width = 200;
			tfFocusOut.height = 30;
			addChild(tfFocusOut);
			
			
			var tf2:TextField = new TextField();
			tf2.text = "フォーカスが外れる、または入力操作なし2秒すると、カンマをつける";
			tf2.autoSize = "left";
			tf2.x = 50;
			tf2.y = 180;
			addChild(tf2);
			var tfDelay:DigitTextFieldDelay = new DigitTextFieldDelay();
			tfDelay.x = 50;
			tfDelay.y = 200;
			tfDelay.text = "1234567"
			tfDelay.border = true;
			tfDelay.borderColor = 0x999999;
			tfDelay.width = 200;
			tfDelay.height = 30;
			addChild(tfDelay);
			
		}
	}
}

import flash.events.Event;
import flash.events.FocusEvent;
import flash.events.KeyboardEvent;
import flash.events.TimerEvent;
import flash.text.TextField;
import flash.text.TextFormat;
import flash.utils.Timer;
class DigitTextField extends TextField {
	public function digit():void {
		var txt:String = this.text;
		var txt_array:Array = txt.split(".");
		txt_array[0] = txt_array[0].replace(/,/g, '');
		var i:int;
		var num:int = txt_array[0].length;
		for (i = 0; i < num; i++) {
			if (txt_array[0].charAt(0) == "0") {
				txt_array[0] = txt_array[0].substr(1);
			}else {
				break;
			}
		}
		var keta:int = Math.ceil(txt_array[0].length / 3);
		for (i = 0; i < keta; i++) {
			if(i == 0){
				var n:int = Math.min(3, txt_array[0].length % 3);
				if(n == 0){
					n = 3;
				}
				txt = txt_array[0].substr( -3 * (keta - i), n) + ",";
			}else{
				txt += txt_array[0].substr( -3 * (keta - i), 3) + ",";
			}
		}
		txt = txt.substr(0, txt.length - 1);
		txt += (txt_array[1] != undefined)?"." + txt_array[1]:"";
		if (txt == "") {
			txt = "0";
		}
		super.text = txt;
	}
}

class DigitTextFieldFocusOut extends DigitTextField {
	public function DigitTextFieldFocusOut():void {
		this.defaultTextFormat = new TextFormat("_sans", 24, 0x7CB333, null, null, null, null, null, "right");
		this.restrict = "0-9 \, \.";
		this.type = "input";
		this.addEventListener(Event.ADDED_TO_STAGE, onAddeToStage);
		this.addEventListener(Event.REMOVED_FROM_STAGE, onRemoveFromStage);
		this.addEventListener(KeyboardEvent.KEY_UP, _onKeyUp);
		super();
	}
	override public function get text():String { 
		return super.text.replace(/,/g, '');
	}
	override public function set text(value:String):void {
		super.text = value;
		if (stage && !stage.focus) {
			digit();
		}
	}
	protected function onAddeToStage(e:Event):void {
		digit();
		onRemoveFromStage(null);
		this.addEventListener(FocusEvent.FOCUS_IN, onFocusIn);
		this.addEventListener(FocusEvent.FOCUS_OUT, onFocusOut);
	}
	protected function onRemoveFromStage(e:Event):void {
		this.removeEventListener(FocusEvent.FOCUS_IN, onFocusIn);
		this.removeEventListener(FocusEvent.FOCUS_OUT, onFocusOut);
	}
	protected function onFocusOut(e:Event):void {
		this.defaultTextFormat = new TextFormat("_sans", 24, 0x7CB333, null, null, null, null, null, "right");
		digit();
	}
	protected function onFocusIn(e:Event):void {
		this.defaultTextFormat = new TextFormat("_sans", 24, 0x666666, null, null, null, null, null, "right");
		super.text = this.text.replace(/,/g, '');
	}
	protected function _onKeyUp(e:KeyboardEvent):void {
		if (e.keyCode == 13) {
			stage.focus = null;
		}
	}
}

class DigitTextFieldDelay extends DigitTextFieldFocusOut {
	private var _timer:Timer;
	public var delay:Number;
	public function DigitTextFieldDelay(delay:Number = 2000):void {
		_timer = new Timer(delay, 1);
		this.delay = delay;
		super();
	}
	
	override protected function onAddeToStage(e:Event):void 
	{
		super.onAddeToStage(e);
		_timer.removeEventListener(TimerEvent.TIMER_COMPLETE, onTimerComplete);
		_timer.addEventListener(TimerEvent.TIMER_COMPLETE, onTimerComplete);
	}
	override protected function onRemoveFromStage(e:Event):void 
	{
		_timer.removeEventListener(TimerEvent.TIMER_COMPLETE, onTimerComplete);
		super.onRemoveFromStage(e);
	}
	
	override protected function onFocusOut(e:Event):void 
	{
		_timer.stop();
		super.onFocusOut(e);
	}
	
	override protected function onFocusIn(e:Event):void 
	{
		super.onFocusIn(e);
		timerStart(delay * 2);
	}
	override protected function _onKeyUp(e:KeyboardEvent):void 
	{
		timerStart(delay);
		super._onKeyUp(e);
	}
	
	private function timerStart(delay:Number):void {
		_timer.delay  = delay;
		_timer.reset();
		_timer.start();
	}
	private function onTimerComplete(e:TimerEvent):void {
		if (this.selectionBeginIndex != this.selectionEndIndex) {
			timerStart(delay);
			return;
		}
		stage.focus = null;
		this.defaultTextFormat = new TextFormat("_sans", 24, 0x7CB333, null, null, null, null, null, "right");
		digit();
	}
	
}
