/**
 * Copyright mutantleg ( http://wonderfl.net/user/mutantleg )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/cZpr
 */

package {
    import flash.geom.ColorTransform;
    import flash.filters.BlurFilter;
    import flash.geom.Point;
    import flash.events.MouseEvent;
    import flash.text.TextField;
    import flash.display.BitmapData;
    import flash.events.Event;
    import flash.display.Sprite;

    public class FlashTest extends Sprite {
        public function FlashTest() {
            
            stage.frameRate = 60;
            
            myPart = new xPartSys();
            
            deb = new TextField();
            deb.width=320; deb.height =240;
            deb.textColor=0xFFffFF;
            deb.mouseEnabled = false;
            addChild(deb);
            
            stage.addEventListener(MouseEvent.CLICK, onClick);
            stage.addEventListener(Event.ENTER_FRAME, onEnter);
        }//ctor

        public function onClick(e:MouseEvent):void
        {
            var ax:Number; var ay:Number; 
            ax = stage.mouseX; ay = stage.mouseY
            var i:int; var a:xPart;
            for (i = 0; i < 64; i++)
            {
               a =  myPart.addPart(ax, ay, Math.random()*6-3,Math.random()*4-2);
               a.hp += Math.random()*40; 
               a.rad += Math.random()*8;
               a.rdown = Math.random() *0.1 + 0.1;
               a.gy = 0.1;
               a.vy -= Math.random()*5
            }
            
        }//onclick

        public var deb:TextField;
        
        public var canvas:BitmapData = new BitmapData(465,465,false,0);
        
        public var myPart:xPartSys;

       public var tempPnt:Point = new Point();
       public var tempfilter:BlurFilter = new BlurFilter();
       public var tempCt:ColorTransform = new ColorTransform(1,1,1,1); 
        
        public function onEnter(e:Event):void
        {
          graphics.clear();
          graphics.lineStyle(2,0);
          
          myPart.addPart(stage.mouseX, stage.mouseY, Math.random()*1-0.5,Math.random()*1-0.5);
          
          tempCt.blueOffset = tempCt.greenOffset = tempCt.redOffset = -8;
          
          //canvas.fillRect(canvas.rect, 0);
          canvas.applyFilter(canvas, canvas.rect, tempPnt, tempfilter); 
          canvas.colorTransform(canvas.rect, tempCt);
          
          myPart.update();
          myPart.render(canvas);
          
          graphics.beginBitmapFill(canvas, null,false,false);
            graphics.drawRect(0,0,465,465);
          graphics.endFill();
          
          deb.text = "" + myPart.numAlive;
             
        }//onenter
        
    }//classend
}
import flash.geom.Rectangle;
import flash.display.BitmapData;

internal class xPart
{
  public var cx:Number = 0;
  public var cy:Number = 0;
    
  public var vx:Number = 0;
  public var vy:Number = 0;
  
  public var gy:Number = 0;
  
  public var c:uint = 0;   
  public var rad:Number = 8, rdown:Number = 0;
    
  public var hp:Number = -1;  
    
}//xpart

internal class xPartSys
{
    
    public function xPartSys()
    { reset(); }
    
    public function reset(num:int=512):void
    {
        var i:int;
        vec = new Vector.<xPart>(num,false);
        for (i = 0; i < num; i++)  { vec[i] = new xPart(); }        
        it = 0;
    }//reset
    
    public function addPart(ax:Number, ay:Number, vx:Number=0,vy:Number=0):xPart
    {
      var a:xPart;
      a = vec[it]; it += 1; if (it >= vec.length) { it = 0; }
      a.cx = ax; a.cy = ay;      a.vx = vx; a.vy = vy;
      a.rad = 4;    a.c = 0xFFffFFff;      a.gy = 0;        a.hp = 100;
      a.rdown = 0;
      return a;        
    }//addpart
    
    public var vec:Vector.<xPart>;
    public var it:int = 0;
    public var numAlive:int = 0;
    
    public function update():void
    {
      var i:int; var num:int; var a:xPart;
      num = vec.length; numAlive = 0;
      for (i = 0; i < num; i++)
      {
       a = vec[i];  if (a.hp <= 0) { continue; }
       a.hp -= 1;   a.cx += a.vx; a.cy+=a.vy;
       a.vy += a.gy;
       a.rad -= a.rdown; if (a.rad <= 0) { a.hp =-1;continue;}
       numAlive += 1;
      }//nexti  
    }//update
    
    public var tempRect:Rectangle = new Rectangle();
    public function render(to:BitmapData):void
    {
        
      var i:int; var num:int; var a:xPart;
      num = vec.length;
      for (i = 0; i < num; i++)
      {
       a = vec[i];  if (a.hp <= 0) { continue; }
       tempRect.x=a.cx; tempRect.y= a.cy;
       tempRect.width = a.rad; tempRect.height = a.rad;
        to.fillRect(tempRect, a.c);
      }//nexti        

    }//render
    
    
}//xpartsys



