/**
 * Copyright kazy ( http://wonderfl.net/user/kazy )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/cZeO
 */

// forked from kazy's SPRING TO MOUSE
package
{
	import flash.display.Sprite;
	import flash.events.Event;
	import funnel.*;
	/**
	 * Main
	 * メインクラス.
	 *
	 * 09.12.06 ロクナナワークショップイベント用　製作中
	 */
	public class Main extends Sprite
	{
		private var ball:Ball;
		private var spring:Number = 0.1;
		private var targetX:Number = stage.stageWidth / 2;
		private var targetY:Number = stage.stageHeight / 2;
		private var vx:Number = 0;
		private var vy:Number = 0;
		private var friction:Number = 0.95;
		private var gravity:Number = 15;
		
        private var fioSystem:Fio;
        private var fio:IOModule;
       // 加速度センサのx軸を接続したアナログピン
       private var xAxisPin:Pin;
        // 加速度センサのy軸を接続したアナログピン
        private var yAxisPin:Pin;
		
		/**
		 * コンストラクタ.
		 */
		public function Main()
		{
             var config:Configuration = Fio.FIRMATA;

             // 必要ないアナログ入力をすべて出力にセットする
             config.setDigitalPinMode(17, OUT);    // A3
             config.setDigitalPinMode(18, OUT);    // A4
             config.setDigitalPinMode(19, OUT);    // A5
             config.setDigitalPinMode(20, OUT);    // A6
             config.setDigitalPinMode(21, OUT);    // A7
             fioSystem = new Fio([1], config);
             fio = fioSystem.ioModule(1);

             xAxisPin = fio.analogPin(0);
             yAxisPin = fio.analogPin(1);

             // 2つの軸のそれぞれにフィルタをセット
             xAxisPin.addFilter(new Convolution(Convolution.MOVING_AVERAGE));
             xAxisPin.addFilter(new Scaler(0.30, 0.70, 0, 400));
             yAxisPin.addFilter(new Convolution(Convolution.MOVING_AVERAGE));
             yAxisPin.addFilter(new Scaler(0.30, 0.70, 0, 400));
   
			init();
		}
		/**
		 * 初期化.
		 */
		private function init():void
		{
			ball = new Ball();
			addChild(ball);
			addEventListener(Event.ENTER_FRAME, onEnterFrame);
		}
		/**
		 * onEnterFrame.
		 */
		private function onEnterFrame(event:Event):void
		{
            var dx:Number = yAxisPin.value - ball.x;
            var dy:Number = xAxisPin.value - ball.y;
			var ax:Number = dx * spring;
			var ay:Number = dy * spring;
			//バネ
			vx += ax;
			vy += ay;
			//重力っぽく
			vy += gravity;
			//減速
			vx *= friction;
			vy *= friction;
			//ボールの座標に適応
			ball.x += vx;
			ball.y += vy;
			//ラインを描く
			graphics.clear();
			graphics.lineStyle(1);
			graphics.moveTo(ball.x, ball.y);
			graphics.lineTo(yAxisPin.value, xAxisPin.value);
		}
	}
}

/**
 * Ball
 * ボール生成クラス.
 */
class Ball extends flash.display.Sprite {
	public var radius:Number;
	private var color:uint;
	public var vx:Number = 0;
	public var vy:Number = 0;
	/**
	 * コンストラクタ.
	 */
	public function Ball(radius:Number=40, color:uint=0x990033) {
		this.radius = radius;
		this.color = color;
		init();
	}
	/**
	 * 初期化.
	 */
	public function init():void {
		graphics.beginFill(color);
		graphics.drawCircle(0, 0, radius);
		graphics.endFill();
	}
}