/**
 * Copyright paq ( http://wonderfl.net/user/paq )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/cZHu
 */

package 
{
	import flash.display.Bitmap;
	import flash.display.BitmapData;
	import flash.display.Graphics;
	import flash.display.Shape;
	import flash.display.Sprite;
	import flash.display.StageQuality;
	import flash.events.Event;
	import flash.geom.ColorTransform;
	import idv.cjcat.stardust.common.clocks.SteadyClock;
	import net.hires.debug.Stats;
	
	[SWF(width = 465, height = 465, backgroundColor = 0x000000, frameRate = 60)]
	public class Main extends Sprite 
	{
		static private const COLOR_TRANSFORM:ColorTransform = new ColorTransform (0.9, 0.9, 0.95);
		private var _emitter:MyEmitter;
		private var _canvas:BitmapData;
		
		public function Main():void 
		{
			if (stage) init();
			else addEventListener(Event.ADDED_TO_STAGE, init);
		}
		
		private function init(e:Event = null):void 
		{
			removeEventListener(Event.ADDED_TO_STAGE, init);
			
			_canvas = new BitmapData(465, 465, false, 0x000000);
			var bmp:Bitmap = new Bitmap(_canvas);
			addChild(bmp);
			
			var sp:Shape = new Shape();
			var g:Graphics = sp.graphics;
			g.beginFill(0x00AAAA, 0.5);
			g.drawCircle(10, 10, 10);
			g.beginFill(0x55EEFF);
			g.drawCircle(10, 10, 5);

			var particleBitmap:BitmapData = new BitmapData(20, 20, true, 0x00000000);
			particleBitmap.draw(sp);
			
			_emitter = new MyEmitter(new SteadyClock(30));
			var renderer:CopyPixelsRenderer = new CopyPixelsRenderer(_canvas, particleBitmap);
			renderer.addEmitter(_emitter);
			
			stage.quality = StageQuality.LOW;
			
			addChild(new Stats());
			addEventListener(Event.ENTER_FRAME, loop);
		}
		
		private function loop(e:Event):void 
		{
			_canvas.colorTransform(_canvas.rect, COLOR_TRANSFORM);
			_emitter.point.x = stage.mouseX - 10;
			_emitter.point.y = stage.mouseY - 10;
			_emitter.step();
		}
		
	}
	
}
import flash.display.BitmapData;
import flash.geom.Point;
import idv.cjcat.stardust.common.actions.Age;
import idv.cjcat.stardust.common.actions.DeathLife;
import idv.cjcat.stardust.common.actions.ScaleCurve;
import idv.cjcat.stardust.common.clocks.Clock;
import idv.cjcat.stardust.common.events.EmitterEvent;
import idv.cjcat.stardust.common.initializers.Life;
import idv.cjcat.stardust.common.math.UniformRandom;
import idv.cjcat.stardust.common.particles.ParticleIterator;
import idv.cjcat.stardust.common.renderers.Renderer;
import idv.cjcat.stardust.twoD.actions.Move;
import idv.cjcat.stardust.twoD.emitters.Emitter2D;
import idv.cjcat.stardust.twoD.fields.UniformField;
import idv.cjcat.stardust.twoD.initializers.Position;
import idv.cjcat.stardust.twoD.initializers.Velocity;
import idv.cjcat.stardust.twoD.particles.Particle2D;
import idv.cjcat.stardust.twoD.zones.LazySectorZone;
import idv.cjcat.stardust.twoD.zones.SinglePoint;


class MyEmitter extends Emitter2D 
{
	public var point:SinglePoint;
	
	public function MyEmitter(clock:Clock)
	{
		super(clock)
		
		point = new SinglePoint();
		
		addInitializer(new Position(point));
		addInitializer(new Velocity(new LazySectorZone(3, 1)));
		addInitializer(new Life(new UniformRandom(50, 50)));
		
		addAction(new Move());
		addAction(new Age());
		addAction(new DeathLife());
	}
}

class CopyPixelsRenderer extends Renderer
{
	public var targetBitmapData:BitmapData;
	public var sourceBitmapData:BitmapData;	
	private var point:Point;
	
	public function CopyPixelsRenderer(targetBitmapData:BitmapData = null, sourceBitmapData:BitmapData = null)
	{
		this.targetBitmapData = targetBitmapData;
		this.sourceBitmapData = sourceBitmapData;
		point = new Point(); 
	}

	override protected function render(e:EmitterEvent):void
	{
		if (!targetBitmapData) return;
		
		targetBitmapData.lock();
		var particle:Particle2D;
		var iter:ParticleIterator = e.particles.getIterator();
		while (particle = iter.particle as Particle2D)
		{
			point.x = particle.x;
			point.y = particle.y;
			targetBitmapData.copyPixels(sourceBitmapData, sourceBitmapData.rect, point);
			iter.next();
		}
		targetBitmapData.unlock();
	}
}