/**
 * Copyright ameo ( http://wonderfl.net/user/ameo )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/cY69
 */

//CRUZE CLOCK vol.01
//ただのアナログ時計。機能を加えていきたいもんです。
// forked from HaraMakoto's PigeonClock
package {
    import flash.display.Loader;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.events.TimerEvent;
    import flash.net.URLRequest;
    import flash.utils.Timer;
    
    [SWF(width="300", height="260", backgroundColor="0x0", frameRate="90")]
    public class PigeonClock extends Sprite
    {
        //表示パーツ
         private var _shortDart:Sprite = new Sprite();
         private var base:Sprite = new Sprite();
         private var body:Sprite = new Sprite();
     
        private var loader:Loader = new Loader();
        //ローダー
        private var _allLoader:DataLoaders = new DataLoaders();
        //時計クラス
        private var _clock:ClockMaster = new ClockMaster();
        //鳩アニメ用タイマー
        private var poppotimer:Timer = new Timer(500);
        private var poppo_counter:int = 0;
        //目ざまし角度
        private var _wakeRotate:int=0;
        
        /**
         * 鳩時計を作ります。
         */
        /**
         * コンストラクタ
         * データ読み込み→表示オブジェクトを配置→鳩を1回実行→時計スタートの順番
         */
        public function PigeonClock()
        {
            _step1_dataload(); //ステップ１ データ読み込み
        }
        //ステップ１ データ読み込み
        private function _step1_dataload():void
        {
            //読み込み完了ハンドラ
            _allLoader.addEventListener(Event.COMPLETE, _LoadComplete);
            //読み込み開始
            _allDataLoad();
        }
        //データを読み込む関数
        private function _allDataLoad():void
        {
            _allLoader.addLoadItem("short", "http://www.geocities.jp/raininess_place/image/flash/cevc02_hari.gif");
            _allLoader.addLoadItem("body", "http://www.geocities.jp/raininess_place/image/flash/cevc02_moji.gif");            
            _allLoader._loadStart();
        }
        //読み込み完了ハンドラ
        private function _LoadComplete(e:Event):void
        {
            _step2_setItems(); //ステップ2　Displayアイテムの配置
            _step3_setClock(); //ステップ３　時計イベントの設定
        }
        
        //ステップ2　Displayアイテムの配置
        private function _step2_setItems():void
        {
            //１ 読み込んだデータを、あらかじめ用意したMCに配置する
            //本体
            body.addChild(_allLoader.items.body);
            //短針
            _shortDart.addChild(_allLoader.items.short);
                _allLoader.items.short.x = -_allLoader.items.short.width/2;
                _allLoader.items.short.y = -_allLoader.items.short.height-30;
            
            //2 データが配置されたMCをステージに配置する
            addChild(body);
             body.addChild(base);
              base.addChild(_shortDart);

            base.x = 300/2; base.y = 146;

        }
        
        //ステップ3　時計のイベントの設定
        private function _step3_setClock():void
        {
            _secHandler(null);
            //_minHandler(null);
            //_hourHandler(null);
            _clock.addEventListener(ClockEvent.SECONDS_CHANGED, _secHandler);
            //_clock.addEventListener(ClockEvent.MINUTES_CHANGED, _minHandler);
            //_clock.addEventListener(ClockEvent.HOURS_CHANGED, _hourHandler);
        }
        private function _secHandler(e:ClockEvent):void
        {
            _shortDart.rotation = _clock.hoursDegree;

        }
    }
}
    import flash.display.Sprite;
    import flash.display.Loader;
    import flash.net.URLRequest;
    import flash.events.Event;
    import flash.events.EventDispatcher;
    import flash.display.DisplayObject;
    import flash.display.Bitmap;
    


/**
 *時計を管理するクラス。
 */
class ClockMaster extends EventDispatcher {
    private var _hours:int;
    private var _minutes:int;
    private var _seconds:int;
    private var preSeconds:int;
    private var _dispatcher:DisplayObject;
    public function ClockMaster():void
    {
        _dispatcher = new Sprite();
        _enterFrameHandler(null);
        _dispatcher.addEventListener(Event.ENTER_FRAME, _enterFrameHandler);
    }
    private function _enterFrameHandler(e:Event):void
    {
        var _date:Date = new Date();
        _hours = (_date.getHours());
        _minutes = _date.getMinutes();
        _seconds = _date.getSeconds();
        if (_seconds != preSeconds) { 
            dispatchEvent(new ClockEvent(ClockEvent.SECONDS_CHANGED));
            if (_seconds == 0) { 
                dispatchEvent(new ClockEvent(ClockEvent.MINUTES_CHANGED));
                if (_minutes == 0) {
                    dispatchEvent(new ClockEvent(ClockEvent.HOURS_CHANGED));
                }
            }
        }
        preSeconds = _seconds;
    }
    // 時間を返す
    public function get hours():int { return _hours; } 
    public function get minutes():int { return _minutes; }
    public function get seconds():int { return _seconds; }
    // 上位1桁返す
    public function get hoursUpper():int { return _hours / 10; }
    public function get minutesUpper():int { return _minutes / 10; }
    public function get secondsUpper():int { return _seconds / 10; }
    // 下位1桁返す
    public function get hoursLower():int { return _hours % 10; }
    public function get minutesLower():int { return _minutes % 10; }
    public function get secondsLower():int { return _seconds % 10; } 
    //アナログ時計にした時の針の角度を返す。
    public function get hoursDegree():Number {
        return ((_hours % 12) * 12.5) + 240 + (_minutes * 12.5 / 60) + (_seconds * 12.5 /60 /60);
    }
    public function get minutesDegree():Number {
        return (_minutes * 6) + (_seconds / 10);
    }
    public function get secondsDegree():Number {
        return _seconds * 6;
    }
}


/**
 * データ読み込みクラス
 */
 class DataLoaders extends Sprite {
     private var _counter:int = 0;
     private var _loadNum:int = 0;
     public var items:Object = new Object();
     private var urls:Object = new Object();
     public static var LOADCOMPLETE:String = "loadComp";
     public function DataLoaders() {
         
     }
     public function addLoadItem(_name:String,_url:String):void
     {
         items[_name]=new Loader();
         urls[_name]=_url;
         _loadNum++;
     }
     public function _loadStart():void
     {
         var i:String;
         for(i in items) {
             var loderUnit:Loader = items[i];
             var urlUnit:String = urls[i];
             loderUnit.contentLoaderInfo.addEventListener(Event.COMPLETE, loadCompHandler);
             loderUnit.load(new URLRequest(urlUnit));
         }
     }
     private function loadCompHandler(e:Event):void
     {
         ///if(e.target.content is Bitmap)
         //    Bitmap(e.target.content).smoothing = true;
         _counter++;
         if(_counter == _loadNum){
             dispatchEvent(new Event(Event.COMPLETE));
         }
     }
 }
 
 /**
 *時計イベントクラス
 */
 class ClockEvent extends Event {
     public static const HOURS_CHANGED:String = "hoursChanged";
     public static const MINUTES_CHANGED:String = "minutesChanged";
     public static const SECONDS_CHANGED:String = "secondsChanged";
     public function ClockEvent(type:String, bubbles:Boolean=false, cancelable:Boolean=false){
         super(type, bubbles, cancelable);
     }
     public override function clone():Event { 
         return new ClockEvent(type, bubbles, cancelable);
     }
     public override function toString():String{ 
         return formatToString("ClockEvent", "type", "bubbles", "cancelable", "eventPhase");
     } 
 }
 