/**
 * Copyright kkeisuke ( http://wonderfl.net/user/kkeisuke )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/cY16
 */

package 
{
	import caurina.transitions.Tweener;
	import flash.display.Sprite;
	import flash.display.StageAlign;
	import flash.display.StageScaleMode;
	import flash.events.Event;
	import flash.events.MouseEvent;
	import flash.events.TimerEvent;
	import flash.geom.Point;
	import flash.geom.Rectangle;
	import flash.utils.Timer;
	
	
	/** 
	* ステージ領域を四角で分割。これを再帰処理というのでしょうか？
	* あまりうまく行ってない箇所もあるような。。
	* 
	* http://www.kenjiroharigai.com/
	* 上記を実現したいです。でも、上記には長方形もある。。
	* 
	* 下記、参考にさせていただきました。ありがとうございます。
	* http://beautifl.net/?c=fractal
	*/
	[SWF(backgroundColor = 0xFFFFFF, frameRate = 40, width = 800, height = 600)]
	public class AreaSplit extends Sprite 
	{
		private var rectDataes:/*Rectangle*/Array;
		
		// 削除した Rectangleインスタンスも含む配列
		private var allRectDataes:/*Rectangle*/Array;
		private var boxes:/*Box*/Array;
		private var count:int;
		private var w:Number;
		private var h:Number;
		private var endP:Point;
		
		// 繰り返す関数
		private var func:Function = splitsArea;
		private var timer:Timer = new Timer(200, 1);
		
		private const PROBABILITY:Number = 0.25;
		private const MIN:int = 16;
		private const MAX:int = 84;
		private const SPEED:Number = 0.1;
		
		
		public function AreaSplit():void 
		{
			if (stage) init();
			else addEventListener(Event.ADDED_TO_STAGE, init);
		}
		
		
		private function init(e:Event = null):void 
		{
			removeEventListener(Event.ADDED_TO_STAGE, init);
			
			stage.align = StageAlign.TOP_LEFT;
			stage.scaleMode = StageScaleMode.NO_SCALE;
			
			setUp();
			
			func();
		}
		
		
		private function setUp():void 
		{
			allRectDataes = [];
			boxes = [];
			count = 0;
			rectDataes = [new Rectangle(0, 0, stage.stageWidth, stage.stageHeight)];
			w = stage.stageWidth / 2;
			h = stage.stageHeight / 2;
			endP = new Point(rectDataes[0].left, rectDataes[0].bottom);
		}
		
		
		private function splitsArea():Function
		{
			var parent:Rectangle = rectDataes[0];
			
			var leftBottom:Point = new Point(parent.left, parent.bottom);
			
			// MIN 当分まではスキップしない。
			if (count < MIN || Math.random() >= PROBABILITY)
			{
				rectDataes.shift()
				rectDataes.push(new Rectangle(parent.x, parent.y, w, h));
				rectDataes.push(new Rectangle(parent.x + w, parent.y, w, h));
				rectDataes.push(new Rectangle(parent.x + w, parent.y + h, w, h));
				rectDataes.push(new Rectangle(parent.x, parent.y + h, w, h));
				
			}else 
			{
				//カウントをスキップ
				count++
				
				// 削除したヤツを入れる
				allRectDataes.push(rectDataes.shift());
			}
			
			// このポイントに来たら、w,h をさらに半分にする。
			if (leftBottom.x == endP.x && leftBottom.y == endP.y) 
			{
				w /= 2;
				h /= 2;
			}
			
			if (count < MAX) 
			{
				count++
				
				return func();
				
			}else 
			{
				// 最後に配列をまとめる。
				allRectDataes = allRectDataes.concat(rectDataes);
				setBox();
				
				return new Function();
			}
		}
		
		
		private function setBox():void
		{
			var n:int = allRectDataes.length;
			for (var i: int = 0; i < n; i++) 
			{
				var box:Box = new Box(allRectDataes[i], i);
				box.alpha = 0;
				this.addChild(box);
				
				boxes.push(box);
				
				Tweener.addTween(box, { alpha:1, time:SPEED, delay:SPEED * i + SPEED, transition:"linear", onComplete:complete, onCompleteParams:[box] } );
			}	
		}
		
		
		private function complete(box:Box):void
		{
			box.addEventListener(MouseEvent.CLICK , reSet);
			box.buttonMode = true;
		}
		
		
		private function reSet(e:MouseEvent):void 
		{
			Tweener.removeAllTweens();
			
			var n:int = boxes.length;
			for (var i: int = 0; i < n; i++) 
			{
				boxes[i].buttonMode = false;
				this.removeChild(boxes[i]);
			}
			
			// すこし開始を遅らせる。
			timer.addEventListener(TimerEvent.TIMER_COMPLETE , reStart);
			timer.reset();
			timer.start();
		}
		
		
		private function reStart(e:TimerEvent):void 
		{
			timer.removeEventListener(TimerEvent.TIMER_COMPLETE , reStart);
			
			setUp();
			
			func();
		}
		
	}
	
}



import flash.display.BlendMode;
import flash.display.Sprite;
import flash.geom.Rectangle;
import flash.text.TextField;
import flash.text.TextFieldAutoSize;
import flash.text.TextFormat;


class Box extends Sprite
{
	static private var textFormat:TextFormat = new TextFormat("_sans", 11, 0);
	
	private const FILL_COLOR:uint = 0x336699;
	private const LINE_COLOR:uint = 0x666666;
	private const MIN_ALPHA:Number = 0.3;
	
	
	public function Box(rect:Rectangle, num:int):void 
	{
		this.graphics.beginFill(FILL_COLOR, Math.max(Math.random(), MIN_ALPHA));
		this.graphics.lineStyle(1, LINE_COLOR, 1, true);
		this.graphics.drawRect(0, 0, rect.width, rect.height);
		this.graphics.endFill();
		this.x = rect.x;
		this.y = rect.y;
		
		var tf:TextField = new TextField();
		tf.defaultTextFormat = textFormat;
		tf.selectable = false;
		tf.mouseEnabled = false;
		tf.blendMode = BlendMode.LAYER;
		tf.text = String(num);
		tf.autoSize = TextFieldAutoSize.LEFT
		tf.x = (this.width - tf.width) * 0.5;
		tf.y = (this.height - tf.height) * 0.5;
		this.addChild(tf);
	}
	
}