/**
 * Copyright oxidane88 ( http://wonderfl.net/user/oxidane88 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/cY0I
 */

// forked from onotan's 1223 papervision3D
package{
	
	import flash.events.*;
	import org.papervision3d.cameras.*;
	import org.papervision3d.core.math.*;
	import org.papervision3d.lights.*;
	import org.papervision3d.materials.shadematerials.*;
	import org.papervision3d.materials.utils.*;
	import org.papervision3d.objects.primitives.*;
	import org.papervision3d.view.*;
	
	public class Camera2 extends BasicView{
		
		private const ORBITAL_RADIUS:int = 1500;
		private var cnt :Number =0;
		private var eye :Cube;
		
		public function Camera2():void{
			
			super(0,0,true,false,CameraType.SPRING);
			
			var material:FlatShadeMaterial = new FlatShadeMaterial(new PointLight3D());
			for(var i:int = 0; i<100 ; i++){
				
				var cube:Cube = new Cube(new MaterialsList({all:material}),50,50,50,1,1,1);
				scene.addChild(cube);
				var angle:Number = (i/100)* 360* Math.PI/180;
				cube.x = Math.cos(angle)* ORBITAL_RADIUS;
				cube.z = Math.sin(angle* 2)* ORBITAL_RADIUS;
				cube.y = 0.3* Math.sin(angle)* ORBITAL_RADIUS;
			}
			
			
			eye = new Cube(new MaterialsList({all:material}),50,50,50,1,1,1);
			scene.addChild(eye);
			
			
			camera.target = eye;
			
			SpringCamera3D(camera).mass = 50;
			SpringCamera3D(camera).damping = 30;
			SpringCamera3D(camera).stiffness = 1;
			SpringCamera3D(camera).positionOffset = new Number3D(0,100,0);
			SpringCamera3D(camera).lookOffset = new Number3D(0,100,0);
			
			addEventListener(Event.ENTER_FRAME,loop);
			startRendering();
		}
		
		
		private function loop(e:Event):void{
			cnt += 0.2;
			
			var angle:Number =(cnt/100)* 360* Math.PI/180;
			eye.x = Math.cos(angle)* ORBITAL_RADIUS;
			eye.z = Math.sin(angle* 2)* ORBITAL_RADIUS;
			eye.y = 0.3* Math.sin(angle)* ORBITAL_RADIUS+ 100;
		}
	}
}
