/**
 * Copyright Kay ( http://wonderfl.net/user/Kay )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/cX8o
 */

/*
 * 勝手に動き回っているように見える奴等
 * 実は目標を決めてそれに向かう健気な性格
 * 2D Bacic Version
 */
package {
	import flash.display.*;
	import flash.geom.*;
	[SWF(width=465,height=465)]
	public class Main extends Sprite {
		function Main():void {
			for (var i:uint = 0; i < 32; i++) {
				var movingTarget:Shape = new Shape();
				movingTarget.x = Math.random()*465;
				movingTarget.y = Math.random()*465;
				var Arrow:MovingObject = new MovingObject(movingTarget,
														  new Point(Math.random()*465,Math.random()*465),
														  Math.random()*360,
														  5);
				addChild(Arrow);
			}
		}
	}
}

import flash.display.*;
import flash.events.*;
import flash.geom.*;
class MovingObject extends Sprite {
	private var myTarget:Shape;
	private var pCurrent:Point;
	private var nSpeed:Number = 2;
	public function MovingObject(vTarget:Shape, vPos:Point, vRotation:Number, vSpeed:Number):void {
		myTarget = vTarget;
		pCurrent = vPos;
		rotation = vRotation;
		nSpeed   = vSpeed;
		x = pCurrent.x;
		y = pCurrent.y;
		// Draw
		graphics.beginFill(Math.ceil(Math.random()*0xffffff));
		graphics.moveTo(10,0);
		graphics.lineTo(-30,-5);
		graphics.lineTo(-30,5);
		addEventListener(Event.ENTER_FRAME, xMove);
	}
	private function xMove(e:Event):void {
		// ターゲットまでの距離を求める
		var dist:Number = Point.distance(new Point(x,y), new Point(myTarget.x, myTarget.y));
		// ターゲットに近づいたらターゲットを移動する
		while(dist < 150) {
			myTarget.x = Math.random()*465;
			myTarget.y = Math.random()*465;
			dist = Point.distance(new Point(x,y), new Point(myTarget.x, myTarget.y));
		}
		// ターゲットの方向を得る
		var targetRadian:Number = Math.atan2(myTarget.y-y, myTarget.x-x);
		var targetAngle:Number = targetRadian/Math.PI*180;
		// 角度の差から進む方向を決め、徐々に向きを変える
		var dif:Number = angleBetween(rotation,targetAngle);
		if (Math.abs(dif) > 5) {
			if (dif > 0) {
				rotation+=5;
			} else {
				rotation-=5;
			}
		} else {
			rotation+=dif;
		}
		// 移動
		var radian:Number = rotation / 180 * Math.PI;
		x += Math.cos(radian)*nSpeed;
		y += Math.sin(radian)*nSpeed;
	}
	// 進行方向と目標との角度差を得る
	// -180～180の範囲内
	private function angleBetween(myAngle:Number, targetAngle:Number):Number {
		var diffAngle:Number = targetAngle - myAngle;
		while (diffAngle < 0) diffAngle+=360;
		diffAngle %= 360;
		if (diffAngle > 180) diffAngle = diffAngle-360;
		return (diffAngle);
	}
}