/**
 * Copyright fukt ( http://wonderfl.net/user/fukt )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/cWna
 */

// forked from mimshwright's CMYK Sprayer 2D
package
{
    import flash.display.BlendMode;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.text.TextField;
    import flash.text.TextFieldAutoSize;
    
    import org.as3lib.kitchensync.*;
    import org.as3lib.kitchensync.action.*;
    import org.as3lib.kitchensync.action.group.*;
    import org.as3lib.kitchensync.action.tween.AUTO_TWEEN_VALUE;
    import org.as3lib.kitchensync.action.tween.KSTween;
    import org.as3lib.kitchensync.action.tween.TweenFactory;
    import org.as3lib.kitchensync.easing.*;
    import org.as3lib.kitchensync.utils.*;
    
    [SWF(width='400', height='400', backgroundColor='#FFFFFF', frameRate='100')]
    public class CMYKSprayer extends Sprite
    {    
        public const STAGE_WIDTH:int = 400;
        public const STAGE_HEIGHT:int = 400;
        public const NUMBER_OF_SPRITES:int = 150;
        protected var _useMixing:Boolean = true;
        protected var _bg:Sprite;
        protected var frameRateView:FrameRateView;
        
        public function CMYKSprayer()
        {
            super();
            
            KitchenSync.initialize(this, "2.0");
            
            _bg = new Sprite();
            _bg.graphics.beginFill(0,1);
            _bg.graphics.drawRect(0,0,STAGE_WIDTH, STAGE_HEIGHT);
            _bg.visible = !_useMixing;
            addChild(_bg);
            
            // add children
            Oscillate.defaultFrequency = .1;
            
            // a group executes a tween each frame
            var group:AbstractActionGroup = new KSStaggeredGroup(16);    
            for (var i:int = 0; i < NUMBER_OF_SPRITES; i++) {

                // create and center a new sprite
                var sprite:Sprite = new Sprite();
                sprite.x = stage.width/2; 
                sprite.y = stage.height/2;

                if (_useMixing) { sprite.blendMode = BlendMode.MULTIPLY; }
                switch(Math.floor(Math.random() * 3)) {
                    case 0: sprite.graphics.beginFill(0xFFFF00,1); break; // yellow
                    case 1: sprite.graphics.beginFill(0xFF00FF,1); break; // magenta
                     case 2: sprite.graphics.beginFill(0x00FFFF,1); break; // cyan
                     default: sprite.graphics.beginFill(0x000000,1); // black
                }
                sprite.graphics.drawCircle(0,0,4);
                //sprite.alpha = .5;
                addChild(sprite);
                
                var scale:int = Math.random() * 14 + 1;
                var delay:int = 0;
                var radius:int = Math.random() * 250;
                var angle:int = Math.random() * 360;
                var x:int = sprite.x + Math.cos(angle) * radius;
                var y:int = sprite.y + Math.sin(angle) * radius;
                
                // create tweens for x y and scale
                var tweenx:KSTween = TweenFactory.newTween(sprite, "x", AUTO_TWEEN_VALUE, x, "1d", delay, Oscillate.absoluteSine);
                var tweeny:KSTween = TweenFactory.newTween(sprite, "y", AUTO_TWEEN_VALUE, y, "1d", delay, Oscillate.absoluteSine);
                var tweenxs:KSTween = TweenFactory.newTween(sprite, "scaleX", AUTO_TWEEN_VALUE, scale, "1d", delay, Oscillate.sine);
                var tweenys:KSTween = TweenFactory.newTween(sprite, "scaleY", AUTO_TWEEN_VALUE, scale, "1d", delay, Oscillate.sine);
                
                // add these to the group
                group.addAction(new KSParallelGroup(tweenx, tweeny, tweenxs, tweenys));
            }
            
            // add labels
            
            // framerate display
            frameRateView = new FrameRateView();
            addChild(frameRateView);
            
            // number of children text
            var childrenView:TextField = new TextField();
            childrenView.text = String(NUMBER_OF_SPRITES) + " children";
            childrenView.autoSize = TextFieldAutoSize.LEFT;
            childrenView.y = 30;
            addChild(childrenView);

            var mixButtonLabel:TextField = new TextField();
            mixButtonLabel.text = "toggle mix";
            mixButtonLabel.textColor = 0xFFFFFF;
            mixButtonLabel.autoSize = TextFieldAutoSize.LEFT;
            mixButtonLabel.selectable = false;
            
            var mixButton:Sprite = new Sprite();
            mixButton.y = 50;
            mixButton.graphics.beginFill(0,1);
            mixButton.graphics.drawRect(0,0, mixButtonLabel.width, mixButtonLabel.height);
            addChild(mixButton);
            mixButton.addChild(mixButtonLabel);
            
            mixButton.addEventListener(MouseEvent.CLICK, toggleMixing);
            
            // execute the group.
            group.start();
            
            toggleMixing();
        }
        
        public function toggleMixing(event:Event = null):void {
            _useMixing = !_useMixing;
            _bg.visible = _useMixing ? false : true;
            frameRateView.textColor = _useMixing ? 0 : 0xFFFFFF; 
            for (var i:int = 0; i < numChildren; i++) { 
                var blob:Sprite = getChildAt(i) as Sprite;
                if (blob != null) {
                    if (_useMixing) { blob.blendMode = BlendMode.MULTIPLY; }
                    else { blob.blendMode = BlendMode.NORMAL; }
                }
            }
        }    
    }
}