/**
 * Copyright Scmiz ( http://wonderfl.net/user/Scmiz )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/cU60
 */

package {
    import flash.geom.Point;
    import flash.events.Event;
    import flash.display.Sprite;
    public class FlashTest extends Sprite {
        private var _count:uint;
        private var _isRise:Boolean;
        
        public function FlashTest() {
            _count = 3;
            _isRise = true;
            this.addEventListener(Event.ENTER_FRAME, proc);
        }
        
        private function proc(e:Event):void {
            if (_isRise) {
                if (_count < 30) {
                    ++_count;
                }
                else {
                    _isRise = false;
                }
            }
            else {
                if (_count > 3) {
                    --_count;
                }
                else {
                    _isRise = true;
                }                
            }

            draw(100 + (_count * 3), _count);
        }
        
        private function draw(radius:Number, num:uint):void {
            this.graphics.clear();
            this.graphics.beginFill(0x000000);
            this.graphics.drawRect(0, 0, 465, 465);
            this.graphics.endFill();
            
            
            var centerX:Number = 232.5;
            var centerY:Number = 232.5;
            
            var center:Point = new Point(centerX, centerY);
            
            var current:Point = new Point(centerX, centerY - radius);
            for (var index:uint = 0; index < num + 1; ++index) {
                var ratio:Number = index / num;
                var rad:Number = (Math.PI * 2 * ratio) + (Math.PI * 0.5);
                var cos:Number = Math.cos(rad);
                var sin:Number = Math.sin(rad);
                var next:Point = new Point(centerX + (cos * radius), centerY + (sin * radius));

                var r:uint = 208 + (Math.random() * 48);
                var g:uint = 208 + (Math.random() * 48);
                var b:uint = 208 + (Math.random() * 48);
                var color:uint = (r << 16) + (g << 8) + (b << 0);
                this.graphics.beginFill(color);
                this.graphics.moveTo(center.x, center.y);
                this.graphics.lineTo(current.x, current.y);
                this.graphics.lineTo(next.x, next.y);
                this.graphics.lineTo(center.x, center.y);
                this.graphics.endFill();

                current = next;
            }
            
        }

    }
}