/**
 * Copyright gaziya ( http://wonderfl.net/user/gaziya )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/cTsz
 */

package {
    import flash.geom.Matrix;
    import flash.geom.ColorTransform;
    import flash.display.Shape;
    import flash.geom.Matrix3D;
    import flash.geom.Vector3D;
    import flash.events.Event;
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.Sprite;
    public class FlashTest extends Sprite {
        public function FlashTest() {
            graphics.beginFill(0x008833)                
            graphics.drawRect(0,0,stage.stageWidth,stage.stageHeight)
            var bitmapData:BitmapData = new BitmapData(stage.stageWidth,stage.stageHeight,true,0x0)
            addChild(new Bitmap(bitmapData))
            var shape:Shape = new Shape
            shape.graphics.beginFill(0xff)
            shape.graphics.drawCircle(0,0,2)
            var particle:Vector.<Number> = new Vector.<Number>
            var numParticle:int = 200
            var n:int = numParticle
            while (n--) {
                particle.push(Math.random(), Math.random()*2*Math.PI, (Math.random()+0.1)*0.05*Math.PI)
            }
            addEventListener(Event.ENTER_FRAME, function(e:Event):void {
                bitmapData.colorTransform(bitmapData.rect, new ColorTransform(1,1,1,0.7))
                n = numParticle
                while (n--) {
                    var point:Vector3D = new Vector3D(
                        particle[3*n]*Math.cos(particle[3*n+1]),
                        -3*particle[3*n],
                        particle[3*n]*Math.sin(particle[3*n+1])
                    )
                    particle[3*n+1] = (particle[3*n+1]+particle[3*n+2])%(2*Math.PI)
                    var matrix3D:Matrix3D = new Matrix3D
                    matrix3D.appendScale(100,100,100)
                    matrix3D.appendRotation(15,Vector3D.X_AXIS)
                    point = matrix3D.transformVector(point)
                    var matrix:Matrix = new Matrix
                    matrix.translate(stage.stageWidth/2,stage.stageHeight-60)
                    matrix.translate(point.x,point.y)
                    bitmapData.draw(shape,matrix)
                }
            })            
        }
    }
}