/**
 * Copyright siny ( http://wonderfl.net/user/siny )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/cTeg
 */

// forked from matsu4512's パーティクル
package {
	import flash.display.Bitmap;
	import flash.display.BitmapData;
	import flash.display.BlendMode;
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.events.MouseEvent;
	import flash.filters.BlurFilter;
	import flash.filters.ColorMatrixFilter;
	import flash.geom.Point;

	[SWF(width=465, height=465, backgroundColor=0xcccccc, frameRate=30)]
	
	public class ColorMatrixFilterTest extends Sprite {
		
		// particleを保管するための配列
		private var arrays:Vector.<particle>;
		private var bmpData:BitmapData;
		private var cMtx:ColorMatrixFilter;
		private var bf:BlurFilter;
		
		public function ColorMatrixFilterTest() {
			
			bmpData = new BitmapData(stage.stageWidth, stage.stageHeight, false, 0x000000);
			var bmp:Bitmap = new Bitmap(bmpData);
			addChild(bmp);
			
			cMtx= new ColorMatrixFilter([
				0.95, 0, 0, 0, 1,
				0, 0.95, 0, 0, 1,
				0, 0, 0.95, 0, 1,
				0, 0, 0, 0.95, 1
			]);
			
			bf = new BlurFilter(10, 10, 1);
			
			// 配列の初期化
			arrays = new Vector.<particle>();
			
			// イベントの追加
			stage.addEventListener(MouseEvent.MOUSE_MOVE, onMouseMove);
			this.addEventListener(Event.ENTER_FRAME, onEnterFrame);
		
		}
		
		private function onEnterFrame(event:Event):void {
			
			// 配列の長さを獲得
			var i:int　=　arrays.length;
			
			// 配列の長さの分だけループ
			while(i){
				i--;
				
				// 配列から要素を取りだす
				var p:particle = arrays[i] as particle;
				
				p.alpha = 0.1;
				p.x　+=　p.vx;
				p.y　+=　p.vy;
				p.z　+=　10;
				//p.rotationX += 5;
				//p.rotationY += 3;
				//vyの更新
				//p.vx+=1.8;

				// 削除
				if (p.width < 2)　{
					// 画面から削除
					this.removeChild(p);
					// 配列からも削除
					arrays.splice(i, 1);
					// ヌルを代入
					p=null;
				}
			}
			
			bmpData.draw(this);
			bmpData.applyFilter(bmpData, bmpData.rect, new Point(0, 0), cMtx);
			bmpData.applyFilter(bmpData, bmpData.rect, new Point(0, 0), bf);
		
		}
		
		private function onMouseMove(e:MouseEvent):void　{
			
			var p:particle　=　new particle(mouseX, mouseY, 0, 16*Math.random()-8, 16*Math.random()-8, -20*Math.random(),0xffffff*Math.random());
			this.addChild(p);
			p.blendMode=BlendMode.ADD;
			
			// 配列に格納
			arrays.push(p);
			
		}
	}
}


import flash.display.Sprite;
import flash.filters.BlurFilter;

// クラス「Particle」
// Spriteを継承したクラスを作成する
class particle extends Sprite {
	
	// x方向とy方向とz方向の移動量
	public var vx:Number;
	public var vy:Number;
	public var vz:Number;

	// コンストラクタ
	public function particle(x:Number, y:Number, z:Number, vx:Number, vy:Number, vz:Number, color:uint){
		
		// 変数の初期化
		this.x=x;
		this.y=y;
		this.z=z;
		this.vx=vx;
		this.vy=vy;
		this.vz=vz;
		
		// 円を書く
		graphics.beginFill(color, 1);
		graphics.drawCircle(0, 0, 20 * Math.random());
		graphics.endFill();
		
	}
}
