/**
 * Copyright asou_jp ( http://wonderfl.net/user/asou_jp )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/cRBL
 */

package  
{
    import flash.display.Sprite;
    import flash.display.StageAlign;
    import flash.display.StageScaleMode;
    import flash.events.Event;
    import flash.geom.Point;
    /**
     * @author asou_jp
     */
    public class HimoTest extends Sprite
    {
        public function HimoTest() 
        {
            vector = new Vector.<Joint>();
            for ( var i:int = 0; i < 10; i++) {
                vector.push(new Joint(0, i * 50));
                vector[i].vy = 1;
            }
            addEventListener(Event.ENTER_FRAME, _enterFrameHandler);
            x = stage.stageWidth >> 1;
            y = stage.stageHeight >> 1;
            stage.scaleMode = StageScaleMode.NO_SCALE;
            stage.align = StageAlign.TOP_LEFT;
        }

        private const _G:Number = .4;
        private var vector:Vector.<Joint>;

        private function _enterFrameHandler(e:Event):void 
        {
            var joint:Joint;
            var i:int;

            for ( i = 0; i < vector.length; i++) {
                joint = vector[i];
                joint.x += joint.vx;
                joint.y += joint.vy;
                joint.vx *= 0.99;
                joint.vy *= 0.99;
                joint.vy += _G;
            }

            var p:Point = new Point();
            p.x = mouseX;
            p.y = mouseY;

            for ( i = 0; i < vector.length; i++) {

                joint = vector[i];
                var dx:Number = joint.x - p.x;
                var dy:Number = joint.y - p.y;
                var d:Number = Math.sqrt( dx*dx + dy*dy );
                var r:Number = Math.atan2(dy, dx) * 180 / Math.PI;

                if (d > 100) {
                    d = 100;
                    joint.x =　p.x +  Math.cos(r * Math.PI / 180) * d;
                    joint.y = p.y + Math.sin(r * Math.PI / 180) * d;
                }
                p.x = joint.x;
                p.y = joint.y;
            }
            
            graphics.clear();
            graphics.lineStyle(1,0xFF0000);
            graphics.moveTo(mouseX, mouseY);
            for ( i = 0; i < vector.length; i++) {
                if (i < vector.length-2) {
                    graphics.curveTo(
                        vector[i].x,vector[i].y,
                        (vector[i].x + vector[i+1].x)*.5,
                        (vector[i].y + vector[i+1].y)*.5
                    );

                }
            }

        }

    }
}



internal class Joint
{
    public function Joint(x:Number=0, y:Number=0) 
    {
        this.x = x;
        this.y = y;
        vx = vy = 0;
    }
    public var x:Number;
    public var y:Number;
    public var vx:Number;
    public var vy:Number;
}