/**
 * Copyright yotsu42keisuke ( http://wonderfl.net/user/yotsu42keisuke )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/cR9Z
 */

// forked from ukitazume's forked from: Arduino Test
// forked from kotobuki's Arduino Test
// A simple example illustrates how to use Funnel with
// an Arduino board (via StandardFirmara)
// 
// Inputs:
// * a switch to D12 with a pull-down resistor (e.g. 10kohm)
// 
// Outputs:
// * a LED with a resistor (e.g. 330phm) to D11
// 
// Ref: Getting started with Funnel and Arduino
// http://funnel.cc/Main/GettingStarted

package {
    import flash.display.Sprite;
    import flash.events.Event;
    
    import funnel.*;
    import funnel.gui.ArduinoGUI;
    import funnel.ui.*;
    import flash.events.TimerEvent;
    import flash.utils.Timer;

    public class ArduinoTest extends Sprite {
        // To change number of analog channels, modify this constant
        // 表示するアナログチャンネル数を変更するにはこの定数を変更する
        private const NUM_CHANNELS:int = 1;

        private var aio:Arduino;
        private var pulseGenerator:Timer;
        private var onBoardLED:LED;

        public function ArduinoTest() {
            var config:Configuration = Arduino.FIRMATA;
            //config.setDigitalPinMode(13, PWM);

            aio = new Arduino(config);

            var gui:ArduinoGUI = new ArduinoGUI();
            addChild(gui);
            aio.gui = gui;

            onBoardLED = new LED(aio.digitalPin(13));
            
            pulseGenerator = new Timer(1000);
            pulseGenerator.addEventListener(TimerEvent.TIMER, loop);
            pulseGenerator.start();

        }

        private function loop(event:Event):void {
            onBoardLED.value = 1.0;
        }
    }
}
