/**
 * Copyright tepe ( http://wonderfl.net/user/tepe )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/cPhG
 */

//汎用ウィンドウクラスを作る
package{
    import flash.display.*;
    import flash.ui.*;
    import flash.text.*;
    import flash.events.*;
    public class Main extends Sprite{
        
        public function Main(){
            
            var wPanel:WindowPanel = new WindowPanel();
            addChild(wPanel);
            var tf:TextField = new TextField();
            tf.text = "test";
            tf.type = "input";
            tf.multiline = true;
            wPanel.target = tf;
            wPanel.title = "title";
            var ui:TreeUI = new TreeUI();
            addChild(ui);
            ui.x = 100;
            var node:TreeNode = new TreeNode();
            node.name="test";
            node.add("test2\naaaaa");
            node.add("test3\nggg\nhhh");
            node.add("test3\nggg\nhhh");
            var node2:TreeNode = new TreeNode();
            node2.name ="a";
            node2.addChild(node);
            ui.node = node2;
            ui.render();
            
            

            addChild(ui);
            graphics.clear();
            graphics.beginFill(0xff0000);
            graphics.drawRect(0,0,455,455);
            graphics.endFill();
            // コンテキストメニューオブジェクトを作成
            var context_menu:ContextMenu = new ContextMenu();

            // メニューアイテムを作成
            var menu_item1:ContextMenuItem = new ContextMenuItem("表示テスト１");
            var menu_item2:ContextMenuItem = new ContextMenuItem("表示テスト２");

            // メニューアイテムを登録
            context_menu.customItems = [menu_item1 , menu_item2];
            ui.contextMenu = context_menu;
        }
        
    }

}

import flash.display.*;
import flash.events.*;
import flash.text.*;
class WindowPanel extends Sprite{
    private var _title:String = "";
    private var _mx:Number = 20;
    private var _my:Number = 10;
    private var _target:DisplayObject;
    private var _tf:TextField;
    public function WindowPanel(){
        draw();
        this.addEventListener(MouseEvent.MOUSE_MOVE,onMove);
        this.addEventListener(MouseEvent.MOUSE_OUT,onOut);
        this.addEventListener(MouseEvent.MOUSE_DOWN,onDrag);
        this.addEventListener(MouseEvent.MOUSE_UP,onDrop);
    }
    public function set target(o:DisplayObject):void{
        _target = o;
        this.addChild(o);
        this.x = o.x;
        this.y = o.y;
        o.x=0;
        o.y=0;
        
        draw();
    }
    
    public function set title(t:String):void{
        _title = t;
        draw();
    }


    //タイトル表示
    private function initTF():void{
        _tf = new TextField();
        _tf.text = _title;
        _tf.y = -_my;
        _tf.selectable = false;
        _tf.width = _tf.textWidth+5;
        _tf.height = _tf.textHeight+5;
        this.addChild(_tf);
    }

    //ウィンドウ更新
    public function draw(c:uint=0xffffff,a:Number=0.5):void{
        initTF();
        var w:Number,h:Number;
        if(_target==null){w=this.width;h=this.height;}
        else{ 
            w=_target.width;h=_target.height;
            this.x += _target.x;
            this.y += _target.y;
            _target.x = 0;
            _target.y = 0;
        }
        
        this.graphics.clear();
        this.graphics.lineStyle(0,0x0,a);
        this.graphics.beginFill(c,a);
        this.graphics.drawRect(-_mx,-_my,w+_mx*2,h+_my*2);
        this.graphics.endFill();
    }
    
    private function onOut(e:MouseEvent):void{
        Mouse.cursor = MouseCursor.AUTO;
    }

    private function onMove(e:MouseEvent):void{
        if(e.target == this)Mouse.cursor = MouseCursor.HAND;
        else Mouse.cursor = MouseCursor.AUTO;
    }

        
    private function onDrag(e:MouseEvent):void{
        if(e.target == this){
            this.startDrag();
        }
        draw();
        //this.startDrag();
    }
    private function onDrop(e:MouseEvent):void{
        this.stopDrag();
        draw();
    }
}



import flash.events.*;
import flash.text.*;
import flash.display.*;
import flash.geom.*;
import flash.ui.*;

    class TreeUI extends Sprite{
        private var rootTree:TreeNode = new TreeNode();
        private var treeUI:Sprite = new Sprite();
        private var pen:Pen = new Pen(treeUI.graphics);
        private var wp:WindowPanel = new WindowPanel();
        public function TreeUI(){
            this.addChild(wp);
            wp.target = treeUI;
            rootTree.name="/"
            rootTree.closed = false;
            render();
        }
        
        public function set node(tree:TreeNode):void{
            rootTree = tree;
            render();
            
        }

        
        //描画処理
        public function render():void {
            treeUI.graphics.clear();
            while (treeUI.numChildren > 0) treeUI.removeChildAt(0);
            renderCell(rootTree, 0, 0);//ノード描画
            wp.draw();
        }
        
        private function renderCell(tree:TreeNode, x:Number, y:Number):Number {
            var sy:Number = y;
            var tui:TreeNodeUI = new TreeNodeUI(tree, x, y,this);
            var h:Number = tui.height;
            treeUI.addChild(tui);
            
            y += h+5;
            if (!tree.closed) {//子リストの描画
                var n:Number = 10;
                var vx:Number = x + 7;
                var vy:Number = y;
                
                for each(var child:TreeNode in tree.children) {
                    //pen.moveTo(vx, y+10);
                    pen.moveTo(vx, y+n);
                    pen.lineTo(vx + 10, y + n);//横線
                    //vy = y+10;
                    vy = y+n;
                    y = renderCell(child, x + 20, y);//子リスト
                }
                if(0<tree.children.length){
                    pen.moveTo(vx, sy+15);
                    pen.lineTo(vx, vy);//縦線
                }
            }
            return y;
        }
    }
    



import com.bit101.components.PushButton;

class TreeNodeUI extends Sprite{
    public var node:TreeNode;
    public var treeUI:TreeUI;
    private var _minBtn:PushButton;
    private var tf:TextField;
    
    public function TreeNodeUI(node:TreeNode,x:Number,y:Number,main:TreeUI) {
        this.node = node;
        this.treeUI = main;
        
        
        tf = new TextField();
        tf.autoSize = "left";
        tf.text = node.name;
        tf.backgroundColor = 0xffffff;
        //tf.background =true;
        tf.border=true;

        addChild(tf);
        if(0<node.length){
            _minBtn = createMinBtn(); 
            addChild(_minBtn);
            tf.x = _minBtn.width+2;
        }
        
        this.x = x;
        this.y = y;
    }
    
    //最小化ボタン
    private function createMinBtn():PushButton {
        var result:PushButton = new PushButton(null, 0, 3, "+", minimize);
        result.width = result.height = 14; result.draw();
        result.addEventListener(MouseEvent.CLICK,minimize);
        result.label = (node.closed) ? "+" : "-"; 
        return result;
    }
    
    private function minimize(event:MouseEvent = null):void {
        node.closed = !node.closed;
        treeUI.render();
        if (_minBtn) { 
            _minBtn.label = (node.closed) ? "-" : "+"; 
        }
    }
    
}

class TreeNode {
    
    public static var ID:int = 0;
    public var parent:TreeNode;//親
    public var closed:Boolean = true;//展開状態
    public var name:String = "node" + (ID++);//表示名
    private var _children:Vector.<TreeNode>;//子リスト
    
    public function TreeNode(str:String=null){
        if(str!=null)name=str;
        _children= new Vector.<TreeNode>;
    }

    public function get length():int{
        return _children.length;
    }

    
    public function get children():Vector.<TreeNode>{
        //createChild();
        return _children;
    }
    
    public function createChild():void{
        if(_children==null){//ノードがなければ自動生成
            var c:int = 2 + 5 * Math.random();
            _children = new Vector.<TreeNode>;
            while (c-- > 0) {
                _children.push(new TreeNode);
            }
        }
    }

    
    public function addChild(t:TreeNode):void{
        _children.push(t);
    }
    
    public function add(str:String):void{
        var node:TreeNode = new TreeNode(str);
        _children.push(node);
    }


}

class Pen{
    
        private var g:Graphics;
        private var sx:Number;
        private var sy:Number;
        private var color:uint;
        public function Pen(g:Graphics,c:uint=0x000000){
            this.g = g;
            this.color = c;
        }
        public function moveTo(x:Number, y:Number):void {
            g.moveTo(x, y);
            sx = x;
            sy = y;
        }
        
        public function lineTo(x:Number, y:Number):void {
            g.lineStyle(0,color);
            g.lineTo(x, y);
            sx = x;
            sy = y;
        }
    }

