/**
 * Copyright hacker_y48qdmdh ( http://wonderfl.net/user/hacker_y48qdmdh )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/cP1a
 */

/*
書籍「C言語による最新アルゴリズム辞典」 より
P245 「フラクタルによる画像圧縮」を移植
*/
package {
    import flash.display.Sprite;
    import flash.display.BitmapData;
    import flash.display.Bitmap;
        
    public class FlashTest extends Sprite {
    		private var bmp:Bitmap;
    		private var bmp_data:BitmapData;

		private var parameter:Parameter;    		
		private var table:Vector.<uint>;

        public function FlashTest() {
            // write as3 code here..
     		this.bmp_data = new BitmapData( this.stage.stageWidth, this.stage.stageWidth, false, 0x00FFFFFF );
     		this.bmp = new Bitmap( this.bmp_data );
     		this.addChild( bmp );
     		
     		this.parameter = new Parameter();
			
			this.init();
        }
        
        private function init():void {
        		var param:Parameter = this.parameter;
        		var s:Number = 0;
      		var ip:Vector.<int> = new Vector.<int>( param.length, true );
        		var p:Vector.<Number> = new Vector.<Number>( param.length, true );
        		
        		var i:uint, j:uint, k:uint;
        		
        		for( i=0; i<param.length; ++i ){
        			p[i] = Math.abs( param.a[i] * param.b[i] - param.b[i] * param.c[i] );
        			s += p[i];
        			ip[i] = i; 
        		}
        		
        		for( i=0; i<param.length-1; ++i ){
        			k = i;
        			
        			for( j = i+1; j < param.length; ++j ){
        				if( p[j] < p[k] ) k = j;
        			}
        			
        			var tmp:Number;
        			tmp = p[i];
        			p[i] = p[k];
        			p[k] = tmp;
        			
        			tmp = ip[i];
        			ip[i] = ip[k];
        			ip[k] = tmp;
        		}
        		
        		for( i=0; i<param.length; ++i ){
        			var index:int = param.table_size;
        			k = (param.length * p[i]/s + 0.5 );
        			s -= p[i];
        			
        			this.table = new Vector.<uint>( param.table_size, true );
        			
        			while( k-- > 0 ){
        				this.table[--index] =  ip[i];
        			};
        		}
        		
        		var x:uint, y:uint;
   			x = y = 0;
   			
        		for( i=0; i<30000; ++i ){
        			var rnd:int = Math.random() * param.table_size - 1;
        			j = table[ rnd ];
        			
        			var t:Number;
        			
        			t = param.a[j] * x + param.b[j] * y + param.e[j];
        			y = param.c[j] * x + param.d[j] * y + param.f[j];
        			x = t;
        			
        			if( i>= 10 ){
        				this.bmp_data.setPixel( x, y, 0xffffffff );
        			}
        		}
        }
       

    }
}

class Parameter {
public var left:int = -5;
public var bottom:int = 0;
public var right:int = 5;
public var top:int = 10;
   	
public var length:uint = 4;
public var table_size:uint = 4 * 25;
   	   	    
public var a:Vector.<Number> = new Vector.<Number>( 0.0,  0.85, 0.2, -0.15 );
public var b:Vector.<Number> = new Vector.<Number>( 0.0,  0.04, -0.26, 0.28 );
public var c:Vector.<Number> = new Vector.<Number>( 0.0, -0.04, 0.23, 0.26 );
public var d:Vector.<Number> = new Vector.<Number>( 0.16, 0.85, 0.22, 0.24 );
public var e:Vector.<Number> = new Vector.<Number>( 0.0,  0.0,  0.0, 0.0 );
public var f:Vector.<Number> = new Vector.<Number>( 0.0,  1.6,  1.6, -0.15 );
}