/**
 * Copyright siouxcitizen ( http://wonderfl.net/user/siouxcitizen )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/cNDE
 */

//←↑→↓またはA、W、D、XボタンでCubeオブジェクトを移動させます
//VボタンでY軸に沿ってカメラ視点を変更　Vボタンを押し続けると元の視点に戻ります
//z-sortの問題？でうまくCubeオブジェクト移動処理が表示されないので、足場のPlaneオブジェクトはワイヤーフレーム表示にしました

package {
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.events.KeyboardEvent;
 
    import org.papervision3d.objects.primitives.Plane;
    import org.papervision3d.objects.primitives.Cube;
    import org.papervision3d.materials.ColorMaterial;
    import org.papervision3d.materials.WireframeMaterial;
    import org.papervision3d.materials.utils.MaterialsList;
    import org.papervision3d.view.Viewport3D;
    import org.papervision3d.scenes.Scene3D;
    import org.papervision3d.cameras.Camera3D;
    import org.papervision3d.render.BasicRenderEngine;
 
    [SWF(width="500", height="500", frameRate="60", backgroundColor="#0055ff")]
 
    public class MovieCube extends Sprite
    {
        private var container    : Sprite;
        private var viewport     : Viewport3D;
        private var scene        : Scene3D;
        private var camera       : Camera3D;
        private var material     : ColorMaterial; 
        private var materials    : MaterialsList;
        private var wireFramMate : WireframeMaterial;
        private var planeObj     : Plane; 
        private var cubeObj      : Cube;
        private var renderer     : BasicRenderEngine;

        private var planeSize : int = 700;//Planeオブジェクト1辺の長さ

        //MoviePlaneクラスのコンストラクタ
        public function MovieCube():void
        {          
            //ビューポート生成
            viewport = new Viewport3D(stage.stageWidth, stage.stageHeight);
            addChild(viewport);

            //シーン生成
            scene = new Scene3D();

            //レンダリングエンジン生成
            renderer = new BasicRenderEngine();

            //Planeオブジェクト用ワイヤーフレームマテリアル設定
            wireFramMate = new WireframeMaterial(0xffff00);

    
            //Planeオブジェクト生成
            planeObj= new Plane(wireFramMate, planeSize, planeSize, 16, 16);
            planeObj.rotationX = 90;
            scene.addChild(planeObj);

            //Cubeオブジェクト生成
            materials = new MaterialsList( { all : new ColorMaterial(0xD7261C) } );
            cubeObj = new Cube(materials, 100, 100, 100);
            cubeObj.y = 50;
            scene.addChild(cubeObj);
            
            //カメラ設定
            camera = new Camera3D();
            camera.y = 400;
 
            //イベント処理用リスナを設定
            stage.addEventListener(Event.ENTER_FRAME, onEnterFrame);
            stage.addEventListener(KeyboardEvent.KEY_DOWN, onKeyDown);
        }

        //フレーム毎の処理
        private function onEnterFrame(e:Event):void{
            renderer.renderScene(scene, camera, viewport);
        }
        
        //キーボード入力処理
        //←↑→↓、A、W、D、Xボタン押下時処理(Cubeオブジェクト移動処理)
        //Vボタン押下時処理(カメラ視点変更処理)
        private function onKeyDown(event:KeyboardEvent):void{
            //←ボタンまたはAボタン X軸移動　X座標値増加     
            if ((event.keyCode == 37) || (event.keyCode == 65)) {
                if (cubeObj.x > -300) {cubeObj.x -= 5;}
            //→ボタンまたはDボタン X軸移動　X座標値減少
            } else if ((event.keyCode == 39) || (event.keyCode == 68)) {
                if (cubeObj.x < 300) {cubeObj.x += 5;}
            //↑ボタンまたはWボタン Z軸移動　Z座標値増加
            } else if ((event.keyCode == 38) || (event.keyCode == 87)) {
                if (cubeObj.z < 300) {cubeObj.z += 5;}
            //↓ボタンまたはXボタン Z軸移動　Z座標値減少
            } else if ((event.keyCode == 40) || (event.keyCode == 88)) {
                if (cubeObj.z > -300) {cubeObj.z -= 5;}
            //Vボタン　カメラY軸座標視点変更
            } else if (event.keyCode == 86) {
                camera.y += 100;
                if (camera.y > 500) {camera.y = 0;}
            } 
        }
    }
}
