/**
 * Copyright s8t1h12akj ( http://wonderfl.net/user/s8t1h12akj )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/cMjG
 */



 package jp.nya.project.effects {

  import flash.display.Sprite;
  import flash.display.Bitmap;
  import flash.display.BitmapData;
  import flash.display.PixelSnapping;
  import flash.display.BlendMode;
  import flash.geom.Matrix;
  import flash.geom.Rectangle;
  import flash.geom.Point;
  import flash.geom.ColorTransform;
  import flash.filters.BlurFilter;
  import flash.events.Event;
  import jp.nya.project.effects.EmitLight;
  import jp.nya.project.effects.Fireworks;

  public class DotLight extends Sprite {
    // プロパティ
    private var rect:Rectangle;
    private var canvas:BitmapData;
    private var glow:BitmapData;
    private var sky:BitmapData;
    private var sparkle:BitmapData;
    private var afterglow:BitmapData;
    private static var scale:uint = 4;
    private var gMatrix:Matrix;
    private var sMatrix:Matrix;
    private var aMatrix:Matrix;
    private var colorTrans:ColorTransform;
    private var blur:BlurFilter;
    private var light:EmitLight;
    private var fireworks:Array;
    private var garbage:Array;
    private var colorList:Array;

    // コンストラクタ
    public function DotLight(r:Rectangle) {
      rect = r;
      init();
    }

    // メソッド
    private function init():void {
      sky = new BitmapData(rect.width, rect.height, false, 0xFF000000);
      var bitmap:Bitmap = new Bitmap(sky);
      addChild(bitmap);
      sparkle = new BitmapData(rect.width/scale, rect.height/scale, false, 0xFF000000);
      var sBitmap:Bitmap = new Bitmap(sparkle);
      sBitmap.smoothing = true;
      sBitmap.blendMode = BlendMode.ADD;
      sBitmap.scaleX = sBitmap.scaleY = scale;
      addChild(sBitmap);
      afterglow = new BitmapData(rect.width*2/scale, rect.height*2/scale, false, 0xFF000000);
      var aBitmap:Bitmap = new Bitmap(afterglow, PixelSnapping.AUTO, true);
      aBitmap.scaleX = aBitmap.scaleY = scale/2;
      addChild(aBitmap);
      canvas = new BitmapData(rect.width, 20, false, 0xFF000000);
      var cBitmap:Bitmap = new Bitmap(canvas);
      cBitmap.y = rect.height - 20;
      addChild(cBitmap);
      glow = new BitmapData(rect.width/scale, 20/scale, false, 0xFF000000);
      var gBitmap:Bitmap = new Bitmap(glow);
      gBitmap.smoothing = true;
      gBitmap.blendMode = BlendMode.ADD;
      gBitmap.scaleX = gBitmap.scaleY = scale;
      gBitmap.y = rect.height - 20;
      addChild(gBitmap);
      light = new EmitLight(canvas);
      sMatrix = new Matrix(1/scale, 0, 0, 1/scale, 0, 0);
      aMatrix = new Matrix(2/scale, 0, 0, 2/scale, 0, 0);
      colorTrans = new ColorTransform(0.05, 0.05, 0.05);
      blur = new BlurFilter(2, 2, 1);
      gMatrix = new Matrix(1/scale, 0, 0, 1/scale, 0, 0);
      fireworks = new Array();
      garbage = new Array();
      colorList = new Array();
      colorList.push([0, 60]);
      colorList.push([48, 60]);
      colorList.push([60, 120]);
      colorList.push([300, 270]);
      colorList.push([180, 240]);
      addEventListener(Event.ENTER_FRAME, draw, false, 0, true);
    }
    public function launch():void {
      var firework:Fireworks = new Fireworks(sky);
      firework.id = fireworks.length;
      var colors:Array = colorList[Math.floor(Math.random()*colorList.length)];
      firework.create(colors);
      firework.addEventListener(Fireworks.COMPLETE, complete, false, 0, true);
      fireworks.push(firework);
    }
    private function draw(evt:Event):void {
      light.create(10);
      canvas.lock();
      canvas.fillRect(canvas.rect, 0x00000000);
      light.emit();
      canvas.unlock();
      if (fireworks.length > 0) {
        sky.lock();
        sky.fillRect(sky.rect, 0x00000000);
        if (garbage.length > 0) remove();
        for (var n:uint = 0; n < fireworks.length; n++) {
          var firework:Fireworks = fireworks[n];
          firework.emit();
        }
        sky.unlock();
        sparkle.lock();
        sparkle.fillRect(sparkle.rect, 0x00000000);
        sparkle.draw(sky, sMatrix);
        sparkle.unlock();
      }
      glow.lock();
      glow.draw(canvas, gMatrix);
      glow.unlock();
      afterglow.lock();
      afterglow.draw(sky, aMatrix, colorTrans, BlendMode.ADD);
      afterglow.applyFilter(afterglow, afterglow.rect, new Point(), blur);
      afterglow.unlock();
    }
    private function complete(evt:Event):void {
      var firework:Fireworks = Fireworks(evt.target);
      firework.removeEventListener(Fireworks.COMPLETE, complete);
      garbage.push(firework.id);
    }
    private function remove():void {
      for (var n:uint = 0; n < garbage.length; n++) {
        var id:uint = garbage[n];
        var firework:Fireworks = fireworks[id];
        firework = null;
        fireworks.splice(id, 1);
      }
      reset();
    }
    private function reset():void {
      for (var n:uint = 0; n < fireworks.length; n++) {
        var firework:Fireworks = fireworks[n];
        firework.id = n;
      }
      garbage = new Array();
    }

  }

 }